/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.arp;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import jpcap.JpcapCaptor;
import jpcap.JpcapSender;
import jpcap.NetworkInterface;
import jpcap.packet.ARPPacket;
import jpcap.packet.EthernetPacket;
import jpcap.packet.IPPacket;
import jpcap.packet.Packet;

public class ARP {
    public static void arp(InetAddress ip) throws IOException {
        NetworkInterface[] devices = JpcapCaptor.getDeviceList();
        System.out.println(devices.length);
        NetworkInterface device = null;
        int i = 0;
        while (i < devices.length) {
            System.out.println(devices[i].description);
            ++i;
        }
        device = devices[0];
        if (device == null) {
            throw new IllegalArgumentException(ip + " is not a local address");
        }
        JpcapCaptor captor = JpcapCaptor.openDevice((NetworkInterface)device, (int)2000, (boolean)false, (int)3000);
        captor.setFilter("ip", true);
        JpcapSender sender = captor.getJpcapSenderInstance();
        InetAddress srcip = null;
        i = 0;
        while (i < device.addresses.length) {
            if (device.addresses[i].address instanceof Inet4Address) {
                srcip = device.addresses[i].address;
                break;
            }
            ++i;
        }
        byte[] broadcast = new byte[]{-1, -1, -1, -1, -1, -1};
        ARPPacket arp = new ARPPacket();
        arp.hardtype = 1;
        arp.prototype = (short)2048;
        arp.operation = 1;
        arp.hlen = (short)6;
        arp.plen = (short)4;
        arp.sender_hardaddr = device.mac_address;
        arp.sender_protoaddr = srcip.getAddress();
        arp.target_hardaddr = broadcast;
        arp.target_protoaddr = ip.getAddress();
        EthernetPacket ether = new EthernetPacket();
        ether.frametype = (short)2054;
        ether.src_mac = device.mac_address;
        ether.dst_mac = broadcast;
        arp.datalink = ether;
        sender.sendPacket((Packet)arp);
        while (true) {
            IPPacket p;
            if ((p = (IPPacket)captor.getPacket()) == null) {
                continue;
            }
            System.out.println(p + "--------" + new String(p.data));
        }
    }

    public static void main(String[] args) throws Exception {
        ARP.arp(InetAddress.getByName("192.168.103.70"));
    }
}

