/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.ip;

import cn.com.voltronicpower.ip.SearchThread;
import cn.com.voltronicpower.main.SnmpModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SearchIP
extends Thread {
    private List<String> _ipList;
    private static HashMap<String, Boolean> _checkList;
    private List<String> _snmpList;
    private SnmpModel _snmpModel;
    private boolean _changeMac;

    public static HashMap<String, Boolean> getCheckList() {
        return _checkList;
    }

    public List<String> getSnmpList() {
        return this._snmpList;
    }

    public SearchIP(List<String> list, SnmpModel model, boolean changeMac) {
        this._ipList = list;
        this._snmpModel = model;
        _checkList = new HashMap();
        for (String ip : this._ipList) {
            _checkList.put(ip, false);
        }
        this._snmpList = new ArrayList<String>();
        this._changeMac = changeMac;
    }

    public void putIPintoDatamodel() {
        if (this._changeMac) {
            try {
                SearchIP.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (String ip : this._ipList) {
            SearchThread thread = new SearchThread(this, ip);
            thread.start();
            try {
                SearchIP.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        boolean completed = false;
        while (!completed) {
            boolean result = true;
            for (String ip : this._ipList) {
                if (SearchIP.getCheckList().get(ip).booleanValue()) continue;
                result = false;
                break;
            }
            if (result) {
                completed = true;
            }
            try {
                SearchIP.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this._snmpModel != null) {
            this._snmpModel.setTableData(this._snmpList);
        }
        this._snmpModel.afterScanSetEnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SearchIP searchIP = this;
        synchronized (searchIP) {
            this.putIPintoDatamodel();
        }
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        int item = 1;
        while (item <= 255) {
            list.add("192.168.103." + item);
            ++item;
        }
        item = 1;
        while (item <= 255) {
            list.add("192.168.104." + item);
            ++item;
        }
        item = 1;
        while (item <= 255) {
            list.add("192.168.105." + item);
            ++item;
        }
        item = 1;
        while (item <= 255) {
            list.add("192.168.106." + item);
            ++item;
        }
        SearchIP search = new SearchIP(list, null, false);
        search.start();
    }
}

