/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.main;

import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronicpower.bean.IpInfo;
import cn.com.voltronicpower.bean.SNMPInfo;
import cn.com.voltronicpower.componet.ShowMsgPane;
import cn.com.voltronicpower.dialog.LoginDialog;
import cn.com.voltronicpower.dialog.MyDialog;
import cn.com.voltronicpower.main.SNMPMainJFrame;
import cn.com.voltronicpower.udp.InitMac;
import cn.com.voltronicpower.udp.SearchAction;
import cn.com.voltronicpower.udp.UdpClient;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;

public class SnmpModel {
    public HashMap<String, String> _passwordList = new HashMap();
    public JTextPane _showMsg;
    public static String _publicPwd = "";
    private String _localIP;
    private boolean _isPublic;
    public boolean _isLogin = false;
    public boolean _isCancel = false;
    public List<String> tableList;
    public static String _passwordStr = "";
    private SNMPMainJFrame _frame;

    public void clearLoginStatus() {
        this._isLogin = false;
        this._isCancel = false;
    }

    public void setLoginCancel(boolean cancel) {
        this._isCancel = cancel;
    }

    public void setLocalIP(String ip) {
        this._localIP = ip;
    }

    public String getLocalIP() {
        return this._localIP;
    }

    public void setIsPublic(boolean isPublic) {
        this._isPublic = isPublic;
    }

    public SnmpModel(SNMPMainJFrame frame, JTextPane showMsg) {
        this._showMsg = showMsg;
        this._frame = frame;
    }

    public HashMap<String, String> getPassworkList() {
        return this._passwordList;
    }

    public void setTableData(List<String> ipList) {
        ArrayList<SNMPInfo> lists = new ArrayList<SNMPInfo>();
        this.sort(ipList);
        for (String ip : ipList) {
            SearchAction action = new SearchAction(ip);
            try {
                String macAddress = action.getMac();
                SNMPInfo info = new SNMPInfo();
                info.setIpAddress(ip);
                info.setMacAddress(macAddress);
                lists.add(info);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.tableList = ipList;
        this._frame.setTableData(lists);
    }

    public void removeTableip(String ip) {
        if (this.tableList != null && this.tableList.contains(ip)) {
            this.tableList.remove(ip);
        }
        this.setTableData(this.tableList);
    }

    public void addTableip(String ip) {
        if (this.tableList != null && !this.tableList.contains(ip)) {
            this.tableList.add(ip);
        }
        this.setTableData(this.tableList);
    }

    public void afterScanSetEnable() {
        this._frame.afterScanSetEnable();
    }

    public void disableAll() {
        SNMPMainJFrame.setEnabledAll(false);
    }

    public void enabledAll() {
        SNMPMainJFrame.setEnabledAll(true);
    }

    public IpInfo initOne() {
        SearchAction action = new SearchAction(this.getLocalIP());
        action.setShowMsg(this._showMsg);
        IpInfo info = null;
        try {
            action.setMac(this.getLocalIP());
            info = action.searchIPInfo();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return info;
    }

    public void initAll(Object[] list) {
        ShowMsgPane.showMsg(this._showMsg, "label.message13", true);
        ArrayList<String> snmpList = new ArrayList<String>();
        int item = 0;
        while (item < list.length) {
            snmpList.add(list[item].toString());
            ++item;
        }
        InitMac init = new InitMac(snmpList, this._showMsg);
        Thread thread = new Thread(init);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean processPwd(SearchAction action) throws IOException {
        boolean result = false;
        String pwd = "";
        if (this.getPassworkList().containsKey(this.getLocalIP())) {
            pwd = this.getPassworkList().get(this.getLocalIP());
        } else if (!"".equals(_publicPwd)) {
            pwd = _publicPwd;
        }
        if (pwd != null && !"".equals(pwd)) {
            if (action.checkPassword(pwd)) {
                result = true;
                this._isLogin = true;
            } else {
                this._isLogin = false;
            }
        }
        return result;
    }

    public boolean processPwd(SearchAction action, String ip) throws IOException {
        boolean result = false;
        String pwd = "";
        if (this.getPassworkList().containsKey(ip)) {
            pwd = this.getPassworkList().get(ip);
        } else if (!"".equals(_publicPwd)) {
            pwd = _publicPwd;
        }
        if (pwd != null && !"".equals(pwd)) {
            if (action.checkPassword(pwd)) {
                result = true;
                this._isLogin = true;
            } else {
                this._isLogin = false;
            }
        }
        return result;
    }

    public boolean submitIpInfo(IpInfo targetInfo) {
        boolean result = true;
        SearchAction action = new SearchAction(this.getLocalIP());
        try {
            this.clearLoginStatus();
            while (!this._isLogin && !this._isCancel) {
                if (this.processPwd(action)) continue;
                ShowMsgPane.showMsg(this._showMsg, "label.message14", true);
                this.showLoginView(false);
                result = false;
            }
            if (!this._isCancel) {
                if (targetInfo.isDhcp()) {
                    if (action.setDhcp(true)) {
                        ShowMsgPane.showMsg(this._showMsg, "label.OperationSuccess", true);
                        result = true;
                    } else {
                        ShowMsgPane.showMsg(this._showMsg, "label.operationfailure", true);
                        result = false;
                    }
                } else if (action.setIpInfo(this.getLocalIP(), targetInfo)) {
                    ShowMsgPane.showMsg(this._showMsg, "label.OperationSuccess", true);
                    if (this._passwordList.get(this.getLocalIP()) != null && !"".equals(this._passwordList.get(this.getLocalIP()))) {
                        this._passwordList.put(targetInfo.getIpAddress(), this._passwordList.get(this.getLocalIP()));
                        this._passwordList.remove(this.getLocalIP());
                    }
                    result = true;
                } else {
                    ShowMsgPane.showMsg(this._showMsg, "label.operationfailure", true);
                    result = false;
                }
            }
        }
        catch (IOException e) {
            ShowMsgPane.showMsg(this._showMsg, "label.message11", true);
            result = false;
        }
        return result;
    }

    public boolean processVersion(SearchAction action, String filename) throws IOException {
        String upversion = filename.substring(filename.length() - 8, filename.length() - 4);
        String downversion = action.executeCommand("get version");
        return !upversion.trim().equals(downversion.trim());
    }

    public boolean setUseSNMPV3(String ip, String value) throws IOException {
        SearchAction action = new SearchAction(ip);
        this.clearLoginStatus();
        while (!this._isCancel && !this._isLogin) {
            if (this.processPwd(action)) continue;
            ShowMsgPane.showMsg(this._showMsg, "label.message14", true);
            this.showLoginView(false);
        }
        return action.setUseSNMPV3(value);
    }

    public void setTrapIP(List<String> list, String ip1, String ip2) {
        int item = 0;
        while (item < list.size()) {
            String ip = list.get(item).toString().trim();
            SearchAction action = new SearchAction(ip);
            try {
                this.clearLoginStatus();
                while (!this._isCancel && !this._isLogin) {
                    if (this.processPwd(action)) continue;
                    ShowMsgPane.showMsg(this._showMsg, "label.message14", true);
                    this.showLoginView(false);
                }
                if (!this._isCancel) {
                    if (!"".equals(ip1)) {
                        if (action.setTrapIP(ip1, 1)) {
                            ShowMsgPane.showMsg(this._showMsg, "[IP address 1]label.OperationSuccess", true);
                        } else {
                            ShowMsgPane.showMsg(this._showMsg, "[IP address 1]label.operationfailure", true);
                        }
                    }
                    if (!"".equals(ip2)) {
                        if (action.setTrapIP(ip2, 2)) {
                            ShowMsgPane.showMsg(this._showMsg, "[IP address 2]label.OperationSuccess", true);
                        } else {
                            ShowMsgPane.showMsg(this._showMsg, "[IP address 2]label.operationfailure", true);
                        }
                    }
                }
            }
            catch (IOException e) {
                ShowMsgPane.showMsg(this._showMsg, "label.message11", true);
            }
            ++item;
        }
    }

    public String getTrapPort() {
        String trapport = GlobalVariables.globalConfig.getTrapPort().trim();
        return trapport;
    }

    public void setTrapPort(List<String> list, String trapPort) {
        int item = 0;
        while (item < list.size()) {
            String ip = list.get(item).toString().trim();
            SearchAction action = new SearchAction(ip);
            try {
                this.clearLoginStatus();
                while (!this._isCancel && !this._isLogin) {
                    if (this.processPwd(action)) continue;
                    ShowMsgPane.showMsg(this._showMsg, "label.message14", true);
                    this.showLoginView(true);
                }
                if (!this._isCancel) {
                    if (action.setTrapPort(trapPort)) {
                        ShowMsgPane.showMsg(this._showMsg, "[" + ip + "]" + "label.OperationSuccess", true);
                    } else {
                        ShowMsgPane.showMsg(this._showMsg, "[" + ip + "]" + "label.operationfailure", true);
                    }
                }
            }
            catch (IOException e) {
                ShowMsgPane.showMsg(this._showMsg, "label.message11", true);
            }
            ++item;
        }
        if (!this._isCancel) {
            try {
                GlobalVariables.globalConfig.setTrapPort(trapPort);
                GlobalVariables.updateProperties(GlobalVariables.globalConfig);
                this.sendUdpForProperties("resettrap");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static boolean isPort(String str) {
        if (str == null || "".equalsIgnoreCase(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        int num = Integer.parseInt(str);
        return num <= 65536 && num >= 1;
    }

    public void initSnmpStatus(List<String> list) {
        int item = 0;
        while (item < list.size()) {
            String ip = null;
            try {
                ip = list.get(item).toString();
                SearchAction action = new SearchAction(ip);
                String status = action.executeCommand("get status");
                if ("0".equals(status)) {
                    action.send("go");
                    action.close();
                }
            }
            catch (Exception e) {
                System.err.println(String.valueOf(ip) + ":" + e.getMessage());
            }
            ++item;
        }
    }

    public static boolean checkPasswordData(JPasswordField field1, JPasswordField field2, JPasswordField field3) {
        boolean result = true;
        String oldpassword = new String(field1.getPassword());
        String newpassword = new String(field2.getPassword());
        String confirmpassword = new String(field3.getPassword());
        if (oldpassword.length() < 8 || oldpassword.length() > 15) {
            MyDialog.showMessageDialog("label.message25", "");
            field1.selectAll();
            field1.requestFocus();
            result = false;
        } else if (newpassword.length() < 8 || newpassword.length() > 15) {
            MyDialog.showMessageDialog("label.message25", "");
            field2.selectAll();
            field2.requestFocus();
            result = false;
        }
        if (!newpassword.equals(confirmpassword)) {
            MyDialog.showMessageDialog("label.message26", "");
            field2.selectAll();
            field2.requestFocus();
            result = false;
        }
        return result;
    }

    public boolean showLoginView(boolean isPublic) {
        boolean result = false;
        LoginDialog login = new LoginDialog(null, true);
        login.setLocationRelativeTo(null);
        login.setVisible(true);
        this.setIsPublic(isPublic);
        int res = login.getReturnValue();
        if (res == 0) {
            result = this.login(_passwordStr, null);
        } else {
            this.setLoginCancel(true);
        }
        return result;
    }

    public boolean showLoginView(boolean isPublic, String ip) {
        boolean result = false;
        LoginDialog login = new LoginDialog(null, true);
        login.setLocationRelativeTo(null);
        login.setVisible(true);
        this.setIsPublic(isPublic);
        int res = login.getReturnValue();
        if (res == 0) {
            result = this.login(_passwordStr, null, ip);
        } else {
            this.setLoginCancel(true);
        }
        return result;
    }

    public boolean login(String password, JLabel errorMsg) {
        boolean result = false;
        if (this._isPublic) {
            _publicPwd = password;
            result = true;
        } else {
            SearchAction action = new SearchAction(this._localIP);
            try {
                if (action.checkPassword(password)) {
                    this._passwordList.put(this._localIP, password);
                    result = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean login(String password, JLabel errorMsg, String ip) {
        boolean result = false;
        if (this._isPublic) {
            _publicPwd = password;
            result = true;
        } else {
            SearchAction action = new SearchAction(ip);
            try {
                if (action.checkPassword(password)) {
                    this._passwordList.put(ip, password);
                    result = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public String[] getIPList() {
        String ipAddress = GlobalVariables.globalConfig.getUpsTreeIpAddress().trim();
        if (ipAddress == null || "".equals(ipAddress)) {
            try {
                String stringIPHead;
                String local = InetAddress.getLocalHost().getHostAddress();
                int lastPointIndex = local.lastIndexOf(46);
                ipAddress = stringIPHead = local.substring(0, lastPointIndex);
                GlobalVariables.globalConfig.setUpsTreeIpAddress(stringIPHead);
                GlobalVariables.updateProperties(GlobalVariables.globalConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String[] ips = ipAddress.split(";");
        return ips;
    }

    public void addIP(String strIP) throws Exception {
        String upsTreeIpAddress = GlobalVariables.globalConfig.getUpsTreeIpAddress().trim();
        String result = "";
        String[] ips = upsTreeIpAddress.split(";");
        boolean isFind = false;
        int item = 0;
        while (item < ips.length) {
            if (strIP.equals(ips[item])) {
                isFind = true;
                break;
            }
            ++item;
        }
        result = isFind ? upsTreeIpAddress : (upsTreeIpAddress != null && !"".equals(upsTreeIpAddress) ? String.valueOf(upsTreeIpAddress) + ";" + strIP : String.valueOf(upsTreeIpAddress) + strIP);
        GlobalVariables.globalConfig.setUpsTreeIpAddress(result);
        GlobalVariables.updateProperties(GlobalVariables.globalConfig);
        this.sendUdpForProperties("updateUPS#add#" + strIP);
    }

    public void delIP(String ip) throws Exception {
        String upsTreeIpAddress = GlobalVariables.globalConfig.getUpsTreeIpAddress().trim();
        ArrayList<String> ipList = new ArrayList<String>();
        if (upsTreeIpAddress != null && !"".equals(upsTreeIpAddress)) {
            String[] s = upsTreeIpAddress.split(";");
            int i = 0;
            while (i < s.length) {
                ipList.add(s[i]);
                ++i;
            }
        }
        if (ipList.contains(ip)) {
            ipList.remove(ip);
        }
        String result = "";
        int item = 0;
        while (item < ipList.size()) {
            result = String.valueOf(result) + (String)ipList.get(item);
            if (item != ipList.size() - 1) {
                result = String.valueOf(result) + ";";
            }
            ++item;
        }
        GlobalVariables.globalConfig.setUpsTreeIpAddress(result);
        GlobalVariables.updateProperties(GlobalVariables.globalConfig);
        this.sendUdpForProperties("updateUPS#del#" + ip);
    }

    public void sendUdpForProperties(String cmd) {
        try {
            UdpClient udp = new UdpClient("127.0.0.1", 2000);
            udp.setPort("41222");
            udp.send(cmd);
            udp.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setDefault(Object[] list) throws IOException {
        boolean result = true;
        int item = 0;
        while (item < list.length) {
            String ip = list[item].toString();
            SearchAction action = new SearchAction(ip);
            this.clearLoginStatus();
            while (!this._isLogin && !this._isCancel) {
                if (this.processPwd(action)) continue;
                ShowMsgPane.showMsg(this._showMsg, "label.message14", true);
                this.showLoginView(false);
            }
            if (this._isCancel) {
                result = false;
                break;
            }
            action.send("set default 1");
            action.close();
            ++item;
        }
        return result;
    }

    public boolean reset(String ip) throws IOException {
        boolean result = false;
        String targetIp = "";
        targetIp = !"".equals(ip) ? ip : this.getLocalIP();
        SearchAction action = new SearchAction(targetIp);
        this.clearLoginStatus();
        while (!this._isLogin && !this._isCancel) {
            if (this.processPwd(action)) continue;
            ShowMsgPane.showMsg(this._showMsg, "[" + targetIp + ":]" + "label.message14", true);
            this.showLoginView(false);
        }
        if (!this._isCancel) {
            action.send("reset");
            action.close();
            result = true;
        }
        return result;
    }

    public boolean changeMac(String mac, String ip) throws IOException {
        boolean result = false;
        String targetIp = "";
        targetIp = !"".equals(ip) ? ip : this.getLocalIP();
        SearchAction action = new SearchAction(targetIp);
        this.clearLoginStatus();
        while (!this._isLogin && !this._isCancel) {
            if (this.processPwd(action)) continue;
            ShowMsgPane.showMsg(this._showMsg, "label.message14", true);
            this.showLoginView(false);
            result = false;
        }
        if (!this._isCancel && action.changeMac(mac)) {
            result = true;
        }
        return result;
    }

    public void sort(List<String> ipList) {
        int size = ipList.size();
        int i = 0;
        while (i < size) {
            int j = size - 1;
            while (j > i) {
                if (this.compareip(ipList.get(i).toString(), ipList.get(j).toString())) {
                    String temp = ipList.get(i);
                    ipList.set(i, ipList.get(j));
                    ipList.set(j, temp);
                }
                --j;
            }
            ++i;
        }
    }

    private boolean compareip(String ip1, String ip2) {
        int intip2;
        String[] ipitems1 = ip1.split("\\.");
        String[] ipitems2 = ip2.split("\\.");
        int intip1 = Integer.parseInt(ipitems1[3]);
        return intip1 > (intip2 = Integer.parseInt(ipitems2[3]));
    }

    public static void main(String[] args) {
        String ip = "192.168.210.21";
        System.out.println(ip.substring(0, ip.lastIndexOf(".")));
    }
}

