/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.udp;

import cn.com.voltronic.util.VolStr;
import cn.com.voltronicpower.utilities.SNMPMyConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.swing.JProgressBar;

public class FTPServer
extends Thread {
    private DatagramSocket _server = null;
    private int _port = 69;
    private String _filepath;
    private String _filename;
    public boolean _start = true;
    private int _block_num;
    private int _tx_datasize;
    public JProgressBar _progress;
    public static boolean SUCCESS_COMPLETED = true;

    public FTPServer(String filepath, String filename, JProgressBar progress, InetAddress address) throws SocketException, UnknownHostException {
        this._server = new DatagramSocket(this._port, address);
        this._server.setSoTimeout(5000);
        System.out.println("FTP server:" + address.getHostAddress());
        this._filepath = filepath;
        this._filename = filename;
        this._progress = progress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                byte[] buffer = new byte[514];
                try {
                    while (true) {
                        if (!this._start) {
                            return;
                        }
                        try {
                            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                            this._server.receive(packet);
                            String revstr = new String(packet.getData(), 0, packet.getLength());
                            String requstType = revstr.substring(0, 2);
                            if (VolStr.getShort((byte)requstType.getBytes()[0], (byte)requstType.getBytes()[1]) != 1) continue;
                            StringBuffer rev_filename = new StringBuffer();
                            int item = 2;
                            while (item < revstr.length() && revstr.charAt(item) != '\u0000') {
                                rev_filename.append(revstr.charAt(item));
                                ++item;
                            }
                            if (this._filename.equalsIgnoreCase(rev_filename.toString().trim())) {
                                InetAddress clientip = packet.getAddress();
                                int clientport = packet.getPort();
                                this.upgrade(clientip, clientport);
                                continue;
                            }
                            SUCCESS_COMPLETED = false;
                            this.close();
                        }
                        catch (UnknownHostException ue) {
                            SUCCESS_COMPLETED = false;
                            ue.printStackTrace();
                        }
                    }
                }
                catch (BindException b) {
                    SUCCESS_COMPLETED = false;
                    b.printStackTrace();
                    return;
                }
            }
            catch (IOException e) {
                SUCCESS_COMPLETED = false;
                System.out.println("run here close all");
                this.close();
                return;
            }
        }
        finally {
            System.out.println("run here close all");
            this.close();
        }
    }

    public void close() {
        try {
            this._start = false;
            this._server.disconnect();
            this._server.close();
            this.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void upgrade(InetAddress ip, int port) throws IOException {
        FileInputStream in = new FileInputStream(new File(this._filepath));
        this._block_num = 0;
        int totalNum = (int)Math.ceil((double)((InputStream)in).available() / 512.0);
        byte[] buffer = new byte[512];
        while ((this._tx_datasize = ((InputStream)in).read(buffer)) != -1) {
            ++this._block_num;
            byte[] resultBuf = new byte[4];
            try {
                this.fnet_tftp_srv_send_data(buffer, ip, port);
                DatagramPacket revdp = new DatagramPacket(resultBuf, resultBuf.length);
                this._server.receive(revdp);
            }
            catch (IOException e) {
                SUCCESS_COMPLETED = false;
                return;
            }
            if (VolStr.getShort((byte)resultBuf[0], (byte)resultBuf[1]) != 4 || VolStr.getShort((byte)resultBuf[2], (byte)resultBuf[3]) != this._block_num) {
                SUCCESS_COMPLETED = false;
                return;
            }
            int percent = (int)Math.floor((float)this._block_num / (float)totalNum * 100.0f);
            SNMPMyConstants.showPercent(this._progress, percent);
        }
        this.close();
        ((InputStream)in).close();
    }

    private void fnet_tftp_srv_send_data(byte[] data, InetAddress ip, int port) throws IOException {
        byte[] buffer = new byte[516];
        buffer[0] = 0;
        buffer[1] = 3;
        byte[] block = VolStr.getBytes((short)((short)this._block_num));
        buffer[2] = block[0];
        buffer[3] = block[1];
        int byte_i = 0;
        while (byte_i < this._tx_datasize) {
            buffer[4 + byte_i] = data[byte_i];
            ++byte_i;
        }
        DatagramPacket dp = new DatagramPacket(buffer, this._tx_datasize + 4, ip, port);
        this._server.send(dp);
    }

    public void fnet_tftp_srv_send_error(byte[] data, short error_code, String error_message, InetAddress ip) throws IOException {
        byte[] errbuffer = new byte[516];
        errbuffer[0] = 0;
        errbuffer[1] = 5;
        byte[] error = VolStr.getBytes((short)error_code);
        errbuffer[2] = error[0];
        errbuffer[3] = error[1];
        int byte_i = 0;
        while (byte_i < 514) {
            errbuffer[4 + byte_i] = data[byte_i];
            ++byte_i;
        }
        DatagramPacket dp = new DatagramPacket(errbuffer, this._tx_datasize + 4, ip, this._port);
        this._server.send(dp);
    }
}

