/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.udp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ping
implements Serializable {
    private static final long serialVersionUID = -8956091528193590506L;
    private static final String osName = System.getProperty("os.name");
    private String destAddress = "";
    private int sent = 0;
    private int received = 0;
    private int lost = 0;
    private float minimum = 0.0f;
    private float maxmum = 0.0f;
    private float average = 0.0f;
    public static boolean result = false;

    public static Ping getInstance(String destHost, int count) {
        Ping ping = new Ping();
        result = false;
        String pingCmd = Ping.getCommand(destHost, count);
        if (!pingCmd.equals("")) {
            try {
                Process proc = Runtime.getRuntime().exec(pingCmd);
                InputStream is = proc.getInputStream();
                List<String> lineList = Ping.printInputStream(is);
                Pattern sRegex = Ping.getStatisticsPattern();
                Pattern tRegex = Ping.getTripTimePattern();
                Matcher sMatcher = null;
                Matcher tMatcher = null;
                for (String line : lineList) {
                    sMatcher = sRegex.matcher(line);
                    tMatcher = tRegex.matcher(line);
                    if (sMatcher.matches()) {
                        ping.sent = Integer.valueOf(sMatcher.group(1));
                        ping.received = Integer.valueOf(sMatcher.group(2));
                        ping.lost = Integer.valueOf(sMatcher.group(3));
                    }
                    if (!tMatcher.matches()) continue;
                    ping.minimum = Float.valueOf(tMatcher.group(1)).floatValue();
                    ping.maxmum = Float.valueOf(tMatcher.group(2)).floatValue();
                    ping.average = Float.valueOf(tMatcher.group(3)).floatValue();
                }
                try {
                    int exitVal = proc.exitValue();
                    System.out.println("Process exitValue: " + exitVal);
                    result = exitVal == 0;
                }
                catch (IllegalThreadStateException e) {
                    e.printStackTrace();
                }
                proc.destroy();
                ping.destAddress = destHost;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ping;
    }

    private static String getCommand(String destHost, int count) {
        String command = "";
        if (osName.startsWith("Windows")) {
            command = "ping -n " + count + " " + destHost;
        }
        return command;
    }

    private static List<String> printInputStream(InputStream in) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(in));
        String line = "";
        Pattern pat = Pattern.compile("[\\s]*");
        Matcher mat = null;
        while ((line = bufReader.readLine()) != null) {
            mat = pat.matcher(line);
            if (!mat.matches()) {
                System.out.println(line);
            }
            list.add(line);
        }
        return list;
    }

    private static Pattern getStatisticsPattern() {
        return Pattern.compile(".*Packets: Sent = ([0-9]+), Received = ([0-9]+), Lost = ([0-9]+).*");
    }

    private static Pattern getTripTimePattern() {
        return Pattern.compile(".*Minimum = ([0-9]+)ms, Maximum = ([0-9]+)ms, Average = ([0-9]+)ms.*");
    }

    public String toString() {
        return "destination: " + this.destAddress + "\nsent: " + this.sent + "\nreceived: " + this.received + "\nlost: " + this.lost + "\ntrip time(max): " + this.maxmum + "\ntrip time(min): " + this.minimum + "\ntrip time(ave): " + this.average;
    }

    public static void main(String[] args) {
        Ping.getInstance("192.168.102.111", 10);
    }
}

