/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.udp;

import cn.com.voltronic.util.VolStr;
import cn.com.voltronicpower.bean.IpInfo;
import cn.com.voltronicpower.componet.ShowMsgPane;
import cn.com.voltronicpower.udp.ActionManager;
import cn.com.voltronicpower.udp.FTPServer;
import cn.com.voltronicpower.udp.UpgradeFile;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;

public class SearchAction
extends ActionManager {
    public SearchAction(String ip) {
        super(ip);
    }

    public boolean getDhcp() throws IOException {
        String str = this.executeCommand("get dhcp");
        if (str == null || "".equals(str)) {
            return false;
        }
        return "1".equals(str.trim());
    }

    public String getIp() throws IOException {
        String str = this.executeCommand("get ip");
        return str;
    }

    public boolean setIp(String targetIp) throws IOException {
        boolean result = false;
        String str = this.executeCommand("set ip " + targetIp);
        if (targetIp.equalsIgnoreCase(str)) {
            result = true;
        }
        return result;
    }

    public boolean setDhcp(boolean isDHCP) throws IOException {
        boolean result = true;
        if (isDHCP) {
            this.send("set dhcp 1");
            this.close();
        } else {
            String str = this.executeCommand("set dhcp 0");
            if (!"OK".equalsIgnoreCase(str)) {
                result = false;
            }
        }
        return result;
    }

    public String getMask() throws IOException {
        String str = this.executeCommand("get netmask");
        return str;
    }

    public boolean setMask(String targetMask) throws IOException {
        boolean result = false;
        String str = this.executeCommand("set netmask " + targetMask);
        if (targetMask.equalsIgnoreCase(str)) {
            result = true;
        }
        return result;
    }

    public String getGateway() throws IOException {
        String str = this.executeCommand("get gateway");
        return str;
    }

    public boolean setGateway(String targetGateway) throws IOException {
        boolean result = false;
        String str = this.executeCommand("set gateway " + targetGateway);
        if (targetGateway.equalsIgnoreCase(str)) {
            result = true;
        }
        return result;
    }

    public boolean setVersion(String version) throws IOException {
        boolean result = false;
        String str = this.executeCommand("set version " + version);
        if ("OK".equalsIgnoreCase(str)) {
            result = true;
        }
        return result;
    }

    public String getUseSNMPV3() throws IOException {
        return this.executeCommand("get use snmpv3");
    }

    public boolean setUseSNMPV3(String value) throws IOException {
        boolean result = false;
        String str = this.executeCommand("set use snmpv3 " + value);
        if ("OK".equalsIgnoreCase(str) && this.save()) {
            result = true;
        }
        return result;
    }

    public boolean setTrapIP(String value, int index) throws IOException {
        boolean result = false;
        String command = "";
        command = index == 1 ? "set trapip1 " : "set trapip2 ";
        String str = this.executeCommand(String.valueOf(command) + value);
        if ("OK".equalsIgnoreCase(str) && this.save()) {
            result = true;
        }
        return result;
    }

    public boolean setTrapPort(String port) throws IOException {
        boolean result = false;
        String str = this.executeCommand("set trapport " + port);
        if ("OK".equalsIgnoreCase(str) && this.save()) {
            result = true;
        }
        return result;
    }

    public String getTrapIP(int index) throws IOException {
        return this.executeCommand("get trapip" + index);
    }

    public static void main(String[] args) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer mac = new StringBuffer();
        mac.append("00-");
        long day = 0L;
        long second = 0L;
        try {
            Date date1 = format.parse("2008-12-31");
            Date date = new Date();
            day = (date.getTime() - date1.getTime()) / 86400000L;
            System.out.println(day);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String str = VolStr.leftZero((String)Long.toHexString(day), (int)4);
        mac.append(str.substring(0, 2)).append("-");
        mac.append(str.substring(2)).append("-");
        Calendar d = Calendar.getInstance();
        second = d.get(11) * 60 * 60 + d.get(12) * 60 + d.get(13);
        str = VolStr.leftZero((String)Long.toHexString(second), (int)6);
        mac.append(str.substring(0, 2)).append("-").append(str.substring(2, 4)).append("-").append(str.substring(4));
        System.out.println(mac);
    }

    public boolean save() throws IOException {
        String str = this.executeCommand("save");
        return str.toUpperCase().startsWith("OK");
    }

    public IpInfo searchIPInfo() throws IOException {
        IpInfo ipinfo = new IpInfo();
        ipinfo.setDhcp(this.getDhcp());
        ipinfo.setIpAddress(this.getIp());
        ipinfo.setMask(this.getMask());
        ipinfo.setGateway(this.getGateway());
        ipinfo.setMacAddress(this.getMac());
        ipinfo.setTrapip1(this.getTrapIP(1));
        ipinfo.setTrapip2(this.getTrapIP(2));
        ShowMsgPane.showMsg(this._showMsg, "[" + ipinfo.getIpAddress() + "]" + "label.message16", true);
        return ipinfo;
    }

    public boolean checkPassword(String password) throws IOException {
        return "OK".equalsIgnoreCase(this.executeCommand("login " + password));
    }

    public boolean changePassword(String ip, String oldpassword, String newpassword) throws IOException {
        String res;
        boolean result = false;
        result = this.checkPassword(oldpassword) ? ("OK".equalsIgnoreCase(res = this.executeCommand("set password " + newpassword)) ? this.save() : false) : false;
        return result;
    }

    public String getStatus(String ip) throws IOException {
        String res = this.executeCommand("get status");
        return res;
    }

    public void setMac(String ip) throws IOException {
        String res = this.executeCommand("get status");
        if ("0".equals(res) && "00-00-12-34-56-78".equals(res = this.executeCommand("get mac"))) {
            String mac = this.doMac();
            if (this.checkPassword("Q1f@18*_~zYLyaM")) {
                res = this.executeCommand("set mac " + mac);
                res.equals(mac);
            }
        }
    }

    public boolean changeMac(String mac) throws IOException {
        boolean result = false;
        String str = this.executeCommand("set mac " + mac);
        if (str.equals(mac) && this.save()) {
            result = true;
        }
        return result;
    }

    public String getMac() throws IOException {
        String str = this.executeCommand("get mac");
        return str;
    }

    public String doMac() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer mac = new StringBuffer();
        mac.append("00-");
        long day = 0L;
        long second = 0L;
        try {
            Date date1 = format.parse("2008-12-31");
            Date date = new Date();
            day = (date.getTime() - date1.getTime()) / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String str = VolStr.leftZero((String)Long.toHexString(day), (int)4);
        mac.append(str.substring(0, 2)).append("-");
        mac.append(str.substring(2)).append("-");
        Calendar d = Calendar.getInstance();
        second = d.get(11) * 60 * 60 + d.get(12) * 60 + d.get(13);
        str = VolStr.leftZero((String)Long.toHexString(second), (int)6);
        mac.append(str.substring(0, 2)).append("-").append(str.substring(2, 4)).append("-").append(str.substring(4));
        return mac.toString();
    }

    public boolean setIpInfo(String localIp, IpInfo info) throws IOException {
        boolean result = false;
        result = this.setIp(info.getIpAddress());
        result = result ? this.setMask(info.getMask()) : false;
        result = result ? this.setGateway(info.getGateway()) : false;
        if (result = result ? this.setDhcp(false) : false) {
            if (this.save()) {
                String str = this.executeCommand("change ip", 6000);
                if (str.startsWith("change")) {
                    this.setUdpIp(info.getIpAddress());
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void sendFile(String filePath, String filename) throws IOException {
        boolean sending = true;
        int number = 0;
        String res = "";
        while (sending && number < 5) {
            if (UpgradeFile._isCancel) break;
            if (++number == 1) {
                ShowMsgPane.showMsg(this._showMsg, "[" + this.ip + ":]" + "label.message23" + number, true);
            } else {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ShowMsgPane.showMsg(this._showMsg, "[" + this.ip + ":]" + "label.message24" + number, true);
            }
            InetAddress inetAddress = this.getFtpServerIP(this.ip);
            if (!this.moveSnmpToBoot("upgrade")) continue;
            FTPServer server = new FTPServer(filePath, filename, this._progress, inetAddress);
            FTPServer.SUCCESS_COMPLETED = true;
            this.send("erase all", 12000);
            ShowMsgPane.showMsg(this._showMsg, "[" + this.ip + ":]" + "label.message17", true);
            boolean eraseCompleted = false;
            while (!this.getUdpReceive().equalsIgnoreCase("OK")) {
            }
            eraseCompleted = true;
            ShowMsgPane.showMsg(this._showMsg, "[" + this.ip + ":]" + "label.message18", true);
            this.close();
            if (eraseCompleted) {
                server.start();
                this.executeCommand("tftp " + filename + " " + inetAddress.getHostAddress());
                ShowMsgPane.showMsg(this._showMsg, "[" + this.ip + ":]" + "label.message19", true);
            }
            while (server._start) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!FTPServer.SUCCESS_COMPLETED) continue;
            ShowMsgPane.showMsg(this._showMsg, "[" + this.ip + ":]" + "label.message20", true);
            String version = filename.substring(filename.length() - 8, filename.length() - 4);
            if (!this.checkPassword("Q1f@18*_~zYLyaM") || !this.setVersion(version) || !(res = this.executeCommand("save")).startsWith("OK")) continue;
            this.send("go");
            sending = false;
            System.out.println("gogogo");
            this.close();
        }
    }

    private InetAddress getFtpServerIP(String ip) {
        InetAddress targetIp = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            block4: while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> cardipaddress = ni.getInetAddresses();
                while (cardipaddress.hasMoreElements()) {
                    InetAddress tempIp = cardipaddress.nextElement();
                    String tempStr = tempIp.getHostAddress();
                    if (tempIp.getHostAddress().lastIndexOf(".") > 0) {
                        tempStr = tempIp.getHostAddress().substring(0, tempIp.getHostAddress().lastIndexOf("."));
                    }
                    if (!ip.startsWith(tempStr)) continue;
                    targetIp = tempIp;
                    continue block4;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (targetIp == null) {
            try {
                targetIp = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return targetIp;
    }
}

