/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UdpClient {
    private String ip = "";
    private String port = "51220";
    private int _timeout;
    private DatagramSocket ds = null;
    private InetAddress inetAddress;

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return Integer.parseInt(this.port);
    }

    public UdpClient(String ip, int timeout) throws SocketException, UnknownHostException {
        this.ip = ip;
        this.inetAddress = InetAddress.getByName(this.getIp());
        this._timeout = timeout;
        this.initUDP();
    }

    public void initUDP() throws SocketException {
        this.ds = new DatagramSocket();
        this.ds.setSoTimeout(this._timeout);
    }

    public byte[] receive() throws IOException {
        byte[] buffer = new byte[64];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        return buffer;
    }

    public void disconnect() {
        this.ds.disconnect();
        this.ds.close();
    }

    public void send(String cmd) throws IOException {
        cmd = String.valueOf(cmd) + '\r';
        byte[] cmdb = cmd.getBytes();
        DatagramPacket dp = new DatagramPacket(cmdb, cmdb.length, this.inetAddress, this.getPort());
        this.ds.send(dp);
    }

    public static void main(String[] args) {
        try {
            UdpClient client = new UdpClient("192.168.103.19", 8000);
            client.send("get version");
            StringBuffer str = new StringBuffer();
            boolean find13 = false;
            block2: while (!find13) {
                byte[] temp = client.receive();
                int i = 0;
                while (i < temp.length) {
                    if (temp[i] > 0 && temp[i] != 13) {
                        str.append((char)temp[i]);
                    } else if (temp[i] == 13) {
                        find13 = true;
                        continue block2;
                    }
                    ++i;
                }
            }
            System.out.println("value:" + str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

