/*
 * Decompiled with CFR 0.152.
 */
package usb;

import cn.com.voltronic.solar.socket.SystemTrayUDPClient;
import cn.com.voltronic.solar.system.ShutdownInterface;
import cn.com.voltronic.solar.util.UPSCmdutils;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import usb.IUSBComm;

public class MacUSBRemote
implements ShutdownInterface,
IUSBComm {
    private SystemTrayUDPClient client;
    private ReentrantLock lock = new ReentrantLock();

    public MacUSBRemote() {
        this.client = new SystemTrayUDPClient("localhost", 33656);
        this.startUpUsbServer();
    }

    @Override
    public String sendCommand(String userId, String command) {
        this.lock.lock();
        String result = "";
        try {
            if (userId.trim().length() == 0) {
                return "";
            }
            try {
                int useCRC = 1;
                String cmd = UPSCmdutils.cmdtoString(userId, command, useCRC);
                this.client.send(cmd.getBytes());
                StringBuilder sb = new StringBuilder();
                byte ch = 0;
                byte[] bytes = this.client.receive();
                if (bytes != null) {
                    int i = 0;
                    while (i < bytes.length) {
                        ch = bytes[i];
                        if (ch == 13) break;
                        sb.append((char)ch);
                        ++i;
                    }
                    result = sb.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public String findUSBDevices() {
        this.lock.lock();
        this.startUSBSRVTest();
        String result = "";
        try {
            try {
                String cmd = "findUSBDevices";
                this.client.send(cmd.getBytes());
                result = this.client.receiveString().trim();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public void shutdownOS() {
        this.lock.lock();
        this.startUSBSRVTest();
        try {
            try {
                String cmd = "shutdownOS";
                this.client.send(cmd.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void beep(int time) {
        this.lock.lock();
        this.startUSBSRVTest();
        try {
            try {
                String cmd = UPSCmdutils.actiontoString("beep", "3");
                this.client.send(cmd.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void suspendOS() {
        this.lock.lock();
        this.startUSBSRVTest();
        try {
            try {
                String cmd = "suspendOS";
                this.client.send(cmd.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void closeUSBPort(String usbID) {
        this.lock.lock();
        this.startUSBSRVTest();
        try {
            if (usbID.trim().length() == 0) {
                return;
            }
            try {
                String cmd = UPSCmdutils.actiontoString("closeUSBPort", usbID);
                this.client.send(cmd.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startUpUsbServer() {
        try {
            String file = String.valueOf(System.getProperty("user.dir")) + File.separator + "lib" + File.separator + "usbserver";
            Runtime.getRuntime().exec(file);
            Thread.sleep(1500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startUSBSRVTest() {
        try {
            boolean success = false;
            String result = "";
            this.client.send("TEST".getBytes());
            result = this.client.receiveString().trim();
            if (result.equals("(ACK")) {
                success = true;
            }
            if (!success) {
                this.startUpUsbServer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

