/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.text;

import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;

public class StrBuilder
implements Cloneable {
    static final int CAPACITY = 32;
    private static final long serialVersionUID = 7628716375283629643L;
    protected char[] buffer;
    protected int size;
    private String newLine;
    private String nullText;

    public StrBuilder() {
        this(32);
    }

    public StrBuilder(int n) {
        if (n <= 0) {
            n = 32;
        }
        this.buffer = new char[n];
    }

    public StrBuilder(String string) {
        if (string == null) {
            this.buffer = new char[32];
        } else {
            this.buffer = new char[string.length() + 32];
            this.append(string);
        }
    }

    public String getNewLineText() {
        return this.newLine;
    }

    public StrBuilder setNewLineText(String string) {
        this.newLine = string;
        return this;
    }

    public String getNullText() {
        return this.nullText;
    }

    public StrBuilder setNullText(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.nullText = string;
        return this;
    }

    public int length() {
        return this.size;
    }

    public StrBuilder setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n < this.size) {
            this.size = n;
        } else if (n > this.size) {
            this.ensureCapacity(n);
            int n2 = this.size;
            int n3 = n;
            this.size = n;
            int n4 = n2;
            while (n4 < n3) {
                this.buffer[n4] = '\u0000';
                ++n4;
            }
        }
        return this;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public StrBuilder ensureCapacity(int n) {
        if (n > this.buffer.length) {
            char[] cArray = this.buffer;
            this.buffer = new char[n];
            System.arraycopy(cArray, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    public StrBuilder minimizeCapacity() {
        if (this.buffer.length > this.length()) {
            char[] cArray = this.buffer;
            this.buffer = new char[this.length()];
            System.arraycopy(cArray, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public StrBuilder clear() {
        this.size = 0;
        return this;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.buffer[n];
    }

    public StrBuilder setCharAt(int n, char c) {
        if (n < 0 || n >= this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.buffer[n] = c;
        return this;
    }

    public StrBuilder deleteCharAt(int n) {
        if (n < 0 || n >= this.size) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.deleteImpl(n, n + 1, 1);
        return this;
    }

    public char[] toCharArray() {
        if (this.size == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[this.size];
        System.arraycopy(this.buffer, 0, cArray, 0, this.size);
        return cArray;
    }

    public char[] toCharArray(int n, int n2) {
        int n3 = (n2 = this.validateRange(n, n2)) - n;
        if (n3 == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.buffer, n, cArray, 0, n3);
        return cArray;
    }

    public char[] getChars(char[] cArray) {
        int n = this.length();
        if (cArray == null || cArray.length < n) {
            cArray = new char[n];
        }
        System.arraycopy(this.buffer, 0, cArray, 0, n);
        return cArray;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.buffer, n, cArray, n3, n2 - n);
    }

    public StrBuilder appendNewLine() {
        if (this.newLine == null) {
            this.append(SystemUtils.LINE_SEPARATOR);
            return this;
        }
        return this.append(this.newLine);
    }

    public StrBuilder appendNull() {
        if (this.nullText == null) {
            return this;
        }
        return this.append(this.nullText);
    }

    public StrBuilder append(Object object) {
        if (object == null) {
            return this.appendNull();
        }
        return this.append(object.toString());
    }

    public StrBuilder append(String string) {
        if (string == null) {
            return this.appendNull();
        }
        int n = string.length();
        if (n > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + n);
            string.getChars(0, n, this.buffer, n2);
            this.size += n;
        }
        return this;
    }

    public StrBuilder append(String string, int n, int n2) {
        if (string == null) {
            return this.appendNull();
        }
        if (n < 0 || n > string.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n2 < 0 || n + n2 > string.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            string.getChars(n, n + n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.appendNull();
        }
        int n = stringBuffer.length();
        if (n > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + n);
            stringBuffer.getChars(0, n, this.buffer, n2);
            this.size += n;
        }
        return this;
    }

    public StrBuilder append(StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer == null) {
            return this.appendNull();
        }
        if (n < 0 || n > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n2 < 0 || n + n2 > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            stringBuffer.getChars(n, n + n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return this.appendNull();
        }
        int n = strBuilder.length();
        if (n > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + n);
            System.arraycopy(strBuilder.buffer, 0, this.buffer, n2, n);
            this.size += n;
        }
        return this;
    }

    public StrBuilder append(StrBuilder strBuilder, int n, int n2) {
        if (strBuilder == null) {
            return this.appendNull();
        }
        if (n < 0 || n > strBuilder.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n2 < 0 || n + n2 > strBuilder.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            strBuilder.getChars(n, n + n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(char[] cArray) {
        if (cArray == null) {
            return this.appendNull();
        }
        int n = cArray.length;
        if (n > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + n);
            System.arraycopy(cArray, 0, this.buffer, n2, n);
            this.size += n;
        }
        return this;
    }

    public StrBuilder append(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return this.appendNull();
        }
        if (n < 0 || n > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid startIndex: " + n2);
        }
        if (n2 < 0 || n + n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + n2);
        }
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            System.arraycopy(cArray, n, this.buffer, n3, n2);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(boolean bl) {
        if (bl) {
            this.ensureCapacity(this.size + 4);
            this.buffer[this.size++] = 116;
            this.buffer[this.size++] = 114;
            this.buffer[this.size++] = 117;
            this.buffer[this.size++] = 101;
        } else {
            this.ensureCapacity(this.size + 5);
            this.buffer[this.size++] = 102;
            this.buffer[this.size++] = 97;
            this.buffer[this.size++] = 108;
            this.buffer[this.size++] = 115;
            this.buffer[this.size++] = 101;
        }
        return this;
    }

    public StrBuilder append(char c) {
        int n = this.length();
        this.ensureCapacity(n + 1);
        this.buffer[this.size++] = c;
        return this;
    }

    public StrBuilder append(int n) {
        return this.append(String.valueOf(n));
    }

    public StrBuilder append(long l) {
        return this.append(String.valueOf(l));
    }

    public StrBuilder append(float f) {
        return this.append(String.valueOf(f));
    }

    public StrBuilder append(double d) {
        return this.append(String.valueOf(d));
    }

    public StrBuilder appendWithSeparators(Object[] objectArray, String string) {
        if (objectArray != null && objectArray.length > 0) {
            string = string == null ? "" : string;
            this.append(objectArray[0]);
            int n = 1;
            while (n < objectArray.length) {
                this.append(string);
                this.append(objectArray[n]);
                ++n;
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Collection collection, String string) {
        if (collection != null && collection.size() > 0) {
            string = string == null ? "" : string;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.append(iterator.next());
                if (!iterator.hasNext()) continue;
                this.append(string);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterator iterator, String string) {
        if (iterator != null) {
            string = string == null ? "" : string;
            while (iterator.hasNext()) {
                this.append(iterator.next());
                if (!iterator.hasNext()) continue;
                this.append(string);
            }
        }
        return this;
    }

    public StrBuilder appendPadding(int n, char c) {
        if (n >= 0) {
            this.ensureCapacity(this.size + n);
            int n2 = 0;
            while (n2 < n) {
                this.buffer[this.size++] = c;
                ++n2;
            }
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadLeft(Object object, int n, char c) {
        if (n > 0) {
            this.ensureCapacity(this.size + n);
            String string = object == null ? this.getNullText() : object.toString();
            int n2 = string.length();
            if (n2 >= n) {
                string.getChars(n2 - n, n2, this.buffer, this.size);
            } else {
                int n3 = n - n2;
                int n4 = 0;
                while (n4 < n3) {
                    this.buffer[this.size + n4] = c;
                    ++n4;
                }
                string.getChars(0, n2, this.buffer, this.size + n3);
            }
            this.size += n;
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadLeft(int n, int n2, char c) {
        return this.appendFixedWidthPadLeft(String.valueOf(n), n2, c);
    }

    public StrBuilder appendFixedWidthPadRight(Object object, int n, char c) {
        if (n > 0) {
            this.ensureCapacity(this.size + n);
            String string = object == null ? this.getNullText() : object.toString();
            int n2 = string.length();
            if (n2 >= n) {
                string.getChars(0, n2, this.buffer, this.size);
            } else {
                int n3 = n - n2;
                string.getChars(0, n2, this.buffer, this.size);
                int n4 = 0;
                while (n4 < n3) {
                    this.buffer[this.size + n2 + n4] = c;
                    ++n4;
                }
            }
            this.size += n;
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadRight(int n, int n2, char c) {
        return this.appendFixedWidthPadRight(String.valueOf(n), n2, c);
    }

    public StrBuilder insert(int n, Object object) {
        if (object == null) {
            return this.insert(n, this.nullText);
        }
        return this.insert(n, object.toString());
    }

    public StrBuilder insert(int n, String string) {
        int n2;
        this.validateIndex(n);
        if (string == null) {
            string = this.nullText;
        }
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 > 0) {
            int n4 = this.size + n2;
            this.ensureCapacity(n4);
            System.arraycopy(this.buffer, n, this.buffer, n + n2, this.size - n);
            this.size = n4;
            string.getChars(0, n2, this.buffer, n);
        }
        return this;
    }

    public StrBuilder insert(int n, char[] cArray) {
        this.validateIndex(n);
        if (cArray == null) {
            return this.insert(n, this.nullText);
        }
        int n2 = cArray.length;
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            System.arraycopy(this.buffer, n, this.buffer, n + n2, this.size - n);
            System.arraycopy(cArray, 0, this.buffer, n, n2);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder insert(int n, char[] cArray, int n2, int n3) {
        this.validateIndex(n);
        if (cArray == null) {
            return this.insert(n, this.nullText);
        }
        if (n2 < 0 || n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid offset: " + n2);
        }
        if (n3 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + n3);
        }
        if (n3 > 0) {
            this.ensureCapacity(this.size + n3);
            System.arraycopy(this.buffer, n, this.buffer, n + n3, this.size - n);
            System.arraycopy(cArray, n2, this.buffer, n, n3);
            this.size += n3;
        }
        return this;
    }

    public StrBuilder insert(int n, boolean bl) {
        this.validateIndex(n);
        if (bl) {
            this.ensureCapacity(this.size + 4);
            System.arraycopy(this.buffer, n, this.buffer, n + 4, this.size - n);
            this.buffer[n++] = 116;
            this.buffer[n++] = 114;
            this.buffer[n++] = 117;
            this.buffer[n] = 101;
            this.size += 4;
        } else {
            this.ensureCapacity(this.size + 5);
            System.arraycopy(this.buffer, n, this.buffer, n + 5, this.size - n);
            this.buffer[n++] = 102;
            this.buffer[n++] = 97;
            this.buffer[n++] = 108;
            this.buffer[n++] = 115;
            this.buffer[n] = 101;
            this.size += 5;
        }
        return this;
    }

    public StrBuilder insert(int n, char c) {
        this.validateIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.buffer, n, this.buffer, n + 1, this.size - n);
        this.buffer[n] = c;
        ++this.size;
        return this;
    }

    public StrBuilder insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StrBuilder insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public StrBuilder insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public StrBuilder insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    private void deleteImpl(int n, int n2, int n3) {
        System.arraycopy(this.buffer, n2, this.buffer, n, this.size - n2);
        this.size -= n3;
    }

    public StrBuilder delete(int n, int n2) {
        int n3 = (n2 = this.validateRange(n, n2)) - n;
        if (n3 > 0) {
            this.deleteImpl(n, n2, n3);
        }
        return this;
    }

    public StrBuilder deleteAll(char c) {
        int n = 0;
        while (n < this.size) {
            if (this.buffer[n] == c) {
                int n2 = n;
                while (++n < this.size) {
                    if (this.buffer[n] != c) break;
                }
                int n3 = n - n2;
                this.deleteImpl(n2, n, n3);
                n -= n3;
            }
            ++n;
        }
        return this;
    }

    public StrBuilder deleteFirst(char c) {
        int n = 0;
        while (n < this.size) {
            if (this.buffer[n] == c) {
                this.deleteImpl(n, n + 1, 1);
                break;
            }
            ++n;
        }
        return this;
    }

    public StrBuilder deleteAll(String string) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        if (n > 0) {
            int n3 = this.indexOf(string, 0);
            while (n3 >= 0) {
                this.deleteImpl(n3, n3 + n, n);
                n3 = this.indexOf(string, n3);
            }
        }
        return this;
    }

    public StrBuilder deleteFirst(String string) {
        int n;
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 > 0 && (n = this.indexOf(string, 0)) >= 0) {
            this.deleteImpl(n, n + n2, n2);
        }
        return this;
    }

    public StrBuilder deleteAll(StrMatcher strMatcher) {
        return this.replace(strMatcher, null, 0, this.size, -1);
    }

    public StrBuilder deleteFirst(StrMatcher strMatcher) {
        return this.replace(strMatcher, null, 0, this.size, 1);
    }

    private void replaceImpl(int n, int n2, int n3, String string, int n4) {
        int n5 = this.size - n3 + n4;
        if (n4 != n3) {
            this.ensureCapacity(n5);
            System.arraycopy(this.buffer, n2, this.buffer, n + n4, this.size - n2);
            this.size = n5;
        }
        if (n4 > 0) {
            string.getChars(0, n4, this.buffer, n);
        }
    }

    public StrBuilder replace(int n, int n2, String string) {
        n2 = this.validateRange(n, n2);
        int n3 = string == null ? 0 : string.length();
        this.replaceImpl(n, n2, n2 - n, string, n3);
        return this;
    }

    public StrBuilder replaceAll(char c, char c2) {
        if (c != c2) {
            int n = 0;
            while (n < this.size) {
                if (this.buffer[n] == c) {
                    this.buffer[n] = c2;
                }
                ++n;
            }
        }
        return this;
    }

    public StrBuilder replaceFirst(char c, char c2) {
        if (c != c2) {
            int n = 0;
            while (n < this.size) {
                if (this.buffer[n] == c) {
                    this.buffer[n] = c2;
                    break;
                }
                ++n;
            }
        }
        return this;
    }

    public StrBuilder replaceAll(String string, String string2) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        if (n > 0) {
            int n3 = string2 == null ? 0 : string2.length();
            int n4 = this.indexOf(string, 0);
            while (n4 >= 0) {
                this.replaceImpl(n4, n4 + n, n, string2, n3);
                n4 = this.indexOf(string, n4 + n3);
            }
        }
        return this;
    }

    public StrBuilder replaceFirst(String string, String string2) {
        int n;
        int n2;
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 > 0 && (n = this.indexOf(string, 0)) >= 0) {
            int n4 = string2 == null ? 0 : string2.length();
            this.replaceImpl(n, n + n2, n2, string2, n4);
        }
        return this;
    }

    public StrBuilder replaceAll(StrMatcher strMatcher, String string) {
        return this.replace(strMatcher, string, 0, this.size, -1);
    }

    public StrBuilder replaceFirst(StrMatcher strMatcher, String string) {
        return this.replace(strMatcher, string, 0, this.size, 1);
    }

    public StrBuilder replace(StrMatcher strMatcher, String string, int n, int n2, int n3) {
        n2 = this.validateRange(n, n2);
        return this.replaceImpl(strMatcher, string, n, n2, n3);
    }

    private StrBuilder replaceImpl(StrMatcher strMatcher, String string, int n, int n2, int n3) {
        if (strMatcher == null || this.size == 0) {
            return this;
        }
        int n4 = string == null ? 0 : string.length();
        char[] cArray = this.buffer;
        int n5 = n;
        while (n5 < n2 && n3 != 0) {
            int n6 = strMatcher.isMatch(cArray, n5, n, n2);
            if (n6 > 0) {
                this.replaceImpl(n5, n5 + n6, n6, string, n4);
                n2 = n2 - n6 + n4;
                n5 = n5 + n4 - 1;
                if (n3 > 0) {
                    --n3;
                }
            }
            ++n5;
        }
        return this;
    }

    public StrBuilder reverse() {
        if (this.size == 0) {
            return this;
        }
        int n = this.size / 2;
        char[] cArray = this.buffer;
        int n2 = 0;
        int n3 = this.size - 1;
        while (n2 < n) {
            char c = cArray[n2];
            cArray[n2] = cArray[n3];
            cArray[n3] = c;
            ++n2;
            --n3;
        }
        return this;
    }

    public StrBuilder trim() {
        if (this.size == 0) {
            return this;
        }
        int n = this.size;
        char[] cArray = this.buffer;
        int n2 = 0;
        while (n2 < n && cArray[n2] <= ' ') {
            ++n2;
        }
        while (n2 < n && cArray[n - 1] <= ' ') {
            --n;
        }
        if (n < this.size) {
            this.delete(n, this.size);
        }
        if (n2 > 0) {
            this.delete(0, n2);
        }
        return this;
    }

    public boolean startsWith(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (n > this.size) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.buffer[n2] != string.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean endsWith(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (n > this.size) {
            return false;
        }
        int n2 = this.size - n;
        int n3 = 0;
        while (n3 < n) {
            if (this.buffer[n2] != string.charAt(n3)) {
                return false;
            }
            ++n3;
            ++n2;
        }
        return true;
    }

    public String substring(int n) {
        return this.substring(n, this.size);
    }

    public String substring(int n, int n2) {
        n2 = this.validateRange(n, n2);
        return new String(this.buffer, n, n2 - n);
    }

    public String leftString(int n) {
        if (n <= 0) {
            return "";
        }
        if (n >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, 0, n);
    }

    public String rightString(int n) {
        if (n <= 0) {
            return "";
        }
        if (n >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, this.size - n, n);
    }

    public String midString(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 <= 0 || n >= this.size) {
            return "";
        }
        if (this.size <= n + n2) {
            return new String(this.buffer, n, this.size - n);
        }
        return new String(this.buffer, n, n2);
    }

    public boolean contains(char c) {
        char[] cArray = this.buffer;
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == c) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean contains(String string) {
        return this.indexOf(string, 0) >= 0;
    }

    public boolean contains(StrMatcher strMatcher) {
        return this.indexOf(strMatcher, 0) >= 0;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(char c, int n) {
        int n2 = n = n < 0 ? 0 : n;
        if (n >= this.size) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n3 = n;
        while (n3 < cArray.length) {
            if (cArray[n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2 = n = n < 0 ? 0 : n;
        if (string == null || n >= this.size) {
            return -1;
        }
        int n3 = string.length();
        if (n3 == 1) {
            return this.indexOf(string.charAt(0), n);
        }
        if (n3 == 0) {
            return n;
        }
        if (n3 > this.size) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n4 = n;
        while (n4 < cArray.length - n3) {
            block7: {
                int n5 = 0;
                while (n5 < n3) {
                    if (string.charAt(n5) == cArray[n4 + n5]) {
                        ++n5;
                        continue;
                    }
                    break block7;
                }
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public int indexOf(StrMatcher strMatcher) {
        return this.indexOf(strMatcher, 0);
    }

    public int indexOf(StrMatcher strMatcher, int n) {
        int n2 = n = n < 0 ? 0 : n;
        if (strMatcher == null || n >= this.size) {
            return -1;
        }
        int n3 = this.size;
        char[] cArray = this.buffer;
        int n4 = n;
        while (n4 < n3) {
            if (strMatcher.isMatch(cArray, n4, n, n3) > 0) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        return this.lastIndexOf(c, this.size - 1);
    }

    public int lastIndexOf(char c, int n) {
        int n2 = n = n >= this.size ? this.size - 1 : n;
        if (n < 0) {
            return -1;
        }
        int n3 = n;
        while (n3 >= 0) {
            if (this.buffer[n3] == c) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.size - 1);
    }

    public int lastIndexOf(String string, int n) {
        int n2 = n = n >= this.size ? this.size - 1 : n;
        if (string == null || n < 0) {
            return -1;
        }
        int n3 = string.length();
        if (n3 > 0 && n3 <= this.size) {
            if (n3 == 1) {
                return this.lastIndexOf(string.charAt(0), n);
            }
            int n4 = n - n3 + 1;
            while (n4 >= 0) {
                block8: {
                    int n5 = 0;
                    while (n5 < n3) {
                        if (string.charAt(n5) == this.buffer[n4 + n5]) {
                            ++n5;
                            continue;
                        }
                        break block8;
                    }
                    return n4;
                }
                --n4;
            }
        } else if (n3 == 0) {
            return n;
        }
        return -1;
    }

    public int lastIndexOf(StrMatcher strMatcher) {
        return this.lastIndexOf(strMatcher, this.size);
    }

    public int lastIndexOf(StrMatcher strMatcher, int n) {
        int n2 = n = n >= this.size ? this.size - 1 : n;
        if (strMatcher == null || n < 0) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n3 = n + 1;
        int n4 = n;
        while (n4 >= 0) {
            if (strMatcher.isMatch(cArray, n4, 0, n3) > 0) {
                return n4;
            }
            --n4;
        }
        return -1;
    }

    public StrTokenizer asTokenizer() {
        return new StrBuilderTokenizer();
    }

    public Reader asReader() {
        return new StrBuilderReader();
    }

    public Writer asWriter() {
        return new StrBuilderWriter();
    }

    public boolean equalsIgnoreCase(StrBuilder strBuilder) {
        if (this == strBuilder) {
            return true;
        }
        if (this.size != strBuilder.size) {
            return false;
        }
        char[] cArray = this.buffer;
        char[] cArray2 = strBuilder.buffer;
        int n = this.size - 1;
        while (n >= 0) {
            char c = cArray[n];
            char c2 = cArray2[n];
            if (c != c2 && Character.toUpperCase(c) != Character.toUpperCase(c2)) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean equals(StrBuilder strBuilder) {
        if (this == strBuilder) {
            return true;
        }
        if (this.size != strBuilder.size) {
            return false;
        }
        char[] cArray = this.buffer;
        char[] cArray2 = strBuilder.buffer;
        int n = this.size - 1;
        while (n >= 0) {
            if (cArray[n] != cArray2[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof StrBuilder) {
            return this.equals((StrBuilder)object);
        }
        return false;
    }

    public int hashCode() {
        char[] cArray = this.buffer;
        int n = 0;
        int n2 = this.size - 1;
        while (n2 >= 0) {
            n = 31 * n + cArray[n2];
            --n2;
        }
        return n;
    }

    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.size).append(this.buffer, 0, this.size);
    }

    protected int validateRange(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.size) {
            n2 = this.size;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        return n2;
    }

    protected void validateIndex(int n) {
        if (n < 0 || n > this.size) {
            throw new StringIndexOutOfBoundsException(n);
        }
    }

    class StrBuilderReader
    extends Reader {
        private int pos;
        private int mark;

        StrBuilderReader() {
        }

        public void close() {
        }

        public int read() {
            if (!this.ready()) {
                return -1;
            }
            return StrBuilder.this.charAt(this.pos++);
        }

        public int read(char[] cArray, int n, int n2) {
            if (n < 0 || n2 < 0 || n > cArray.length || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.pos >= StrBuilder.this.size()) {
                return -1;
            }
            if (this.pos + n2 > StrBuilder.this.size()) {
                n2 = StrBuilder.this.size() - this.pos;
            }
            StrBuilder.this.getChars(this.pos, this.pos + n2, cArray, n);
            this.pos += n2;
            return n2;
        }

        public long skip(long l) {
            if ((long)this.pos + l > (long)StrBuilder.this.size()) {
                l = StrBuilder.this.size() - this.pos;
            }
            if (l < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }

        public boolean ready() {
            return this.pos < StrBuilder.this.size();
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int n) {
            this.mark = this.pos;
        }

        public void reset() {
            this.pos = this.mark;
        }
    }

    class StrBuilderTokenizer
    extends StrTokenizer {
        StrBuilderTokenizer() {
        }

        protected List tokenize(char[] cArray, int n, int n2) {
            if (cArray == null) {
                return super.tokenize(StrBuilder.this.buffer, 0, StrBuilder.this.size());
            }
            return super.tokenize(cArray, n, n2);
        }

        public String getContent() {
            String string = super.getContent();
            if (string == null) {
                return StrBuilder.this.toString();
            }
            return string;
        }
    }

    class StrBuilderWriter
    extends Writer {
        StrBuilderWriter() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(int n) {
            StrBuilder.this.append((char)n);
        }

        public void write(char[] cArray) {
            StrBuilder.this.append(cArray);
        }

        public void write(char[] cArray, int n, int n2) {
            StrBuilder.this.append(cArray, n, n2);
        }

        public void write(String string) {
            StrBuilder.this.append(string);
        }

        public void write(String string, int n, int n2) {
            StrBuilder.this.append(string, n, n2);
        }
    }
}

