/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.core.NestedExceptionUtils;

public abstract class NestedCheckedException
extends Exception {
    private static final long serialVersionUID = 7100714597678207546L;
    private Throwable cause;

    public NestedCheckedException(String string) {
        super(string);
    }

    public NestedCheckedException(String string, Throwable throwable) {
        super(string);
        this.cause = throwable;
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public String getMessage() {
        return NestedExceptionUtils.buildMessage(super.getMessage(), this.getCause());
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.getCause() == null) {
            super.printStackTrace(printStream);
        } else {
            printStream.println(this);
            printStream.print("Caused by: ");
            this.getCause().printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.getCause() == null) {
            super.printStackTrace(printWriter);
        } else {
            printWriter.println(this);
            printWriter.print("Caused by: ");
            this.getCause().printStackTrace(printWriter);
        }
    }

    public Throwable getRootCause() {
        Throwable throwable = this.getCause();
        if (throwable instanceof NestedCheckedException) {
            return ((NestedCheckedException)throwable).getRootCause();
        }
        return throwable;
    }

    public Throwable getMostSpecificCause() {
        Throwable throwable = this.getRootCause();
        return throwable != null ? throwable : this;
    }

    public boolean contains(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isInstance(this)) {
            return true;
        }
        Throwable throwable = this.getCause();
        if (throwable instanceof NestedCheckedException) {
            return ((NestedCheckedException)throwable).contains(clazz);
        }
        return throwable != null && clazz.isInstance(throwable);
    }
}

