/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class PropertiesLoaderUtils {
    public static Properties loadProperties(Resource resource) throws IOException {
        Properties properties = new Properties();
        PropertiesLoaderUtils.fillProperties(properties, resource);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillProperties(Properties properties, Resource resource) throws IOException {
        InputStream inputStream = resource.getInputStream();
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    public static Properties loadAllProperties(String string) throws IOException {
        return PropertiesLoaderUtils.loadAllProperties(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAllProperties(String string, ClassLoader classLoader) throws IOException {
        Assert.notNull(string, "Resource name must not be null");
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ClassUtils.getDefaultClassLoader();
        }
        Properties properties = new Properties();
        Enumeration<URL> enumeration = classLoader2.getResources(string);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            InputStream inputStream = null;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                inputStream = uRLConnection.getInputStream();
                properties.load(inputStream);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return properties;
    }
}

