/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultToStringStyler
implements ToStringStyler {
    private final ValueStyler valueStyler;

    public DefaultToStringStyler(ValueStyler valueStyler) {
        Assert.notNull(valueStyler, "ValueStyler must not be null");
        this.valueStyler = valueStyler;
    }

    protected final ValueStyler getValueStyler() {
        return this.valueStyler;
    }

    public void styleStart(StringBuffer stringBuffer, Object object) {
        if (!object.getClass().isArray()) {
            stringBuffer.append('[').append(ClassUtils.getShortName(object.getClass()));
            this.styleIdentityHashCode(stringBuffer, object);
        } else {
            stringBuffer.append('[');
            this.styleIdentityHashCode(stringBuffer, object);
            stringBuffer.append(' ');
            this.styleValue(stringBuffer, object);
        }
    }

    private void styleIdentityHashCode(StringBuffer stringBuffer, Object object) {
        stringBuffer.append('@');
        stringBuffer.append(ObjectUtils.getIdentityHexString(object));
    }

    public void styleEnd(StringBuffer stringBuffer, Object object) {
        stringBuffer.append(']');
    }

    public void styleField(StringBuffer stringBuffer, String string, Object object) {
        this.styleFieldStart(stringBuffer, string);
        this.styleValue(stringBuffer, object);
        this.styleFieldEnd(stringBuffer, string);
    }

    protected void styleFieldStart(StringBuffer stringBuffer, String string) {
        stringBuffer.append(' ').append(string).append(" = ");
    }

    protected void styleFieldEnd(StringBuffer stringBuffer, String string) {
    }

    public void styleValue(StringBuffer stringBuffer, Object object) {
        stringBuffer.append(this.valueStyler.style(object));
    }

    public void styleFieldSeparator(StringBuffer stringBuffer) {
        stringBuffer.append(',');
    }
}

