/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Assert {
    public static void isTrue(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void isTrue(boolean bl) {
        Assert.isTrue(bl, "[Assertion failed] - this expression must be true");
    }

    public static void isNull(Object object, String string) {
        if (object != null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static void notNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not null");
    }

    public static void hasLength(String string, String string2) {
        if (!StringUtils.hasLength(string)) {
            throw new IllegalArgumentException(string2);
        }
    }

    public static void hasLength(String string) {
        Assert.hasLength(string, "[Assertion failed] - this String argument must have length; it must not be <code>null</code> or empty");
    }

    public static void hasText(String string, String string2) {
        if (!StringUtils.hasText(string)) {
            throw new IllegalArgumentException(string2);
        }
    }

    public static void hasText(String string) {
        Assert.hasText(string, "[Assertion failed] - this String argument must have text; it must not be <code>null</code>, empty, or blank");
    }

    public static void doesNotContain(String string, String string2, String string3) {
        if (StringUtils.hasLength(string) && StringUtils.hasLength(string2) && string.indexOf(string2) != -1) {
            throw new IllegalArgumentException(string3);
        }
    }

    public static void doesNotContain(String string, String string2) {
        Assert.doesNotContain(string, string2, "[Assertion failed] - this String argument must not contain the substring [" + string2 + "]");
    }

    public static void notEmpty(Object[] objectArray, String string) {
        if (ObjectUtils.isEmpty(objectArray)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(Object[] objectArray) {
        Assert.notEmpty(objectArray, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Collection collection, String string) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(Collection collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(Map map, String string) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(Map map) {
        Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static void isInstanceOf(Class clazz, Object object) {
        Assert.isInstanceOf(clazz, object, "");
    }

    public static void isInstanceOf(Class clazz, Object object, String string) {
        Assert.notNull(clazz, "Type to check against must not be null");
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(string + "Object of class [" + (object != null ? object.getClass().getName() : "null") + "] must be an instance of " + clazz);
        }
    }

    public static void isAssignable(Class clazz, Class clazz2) {
        Assert.isAssignable(clazz, clazz2, "");
    }

    public static void isAssignable(Class clazz, Class clazz2, String string) {
        Assert.notNull(clazz, "Type to check against must not be null");
        if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException(string + clazz2 + " is not assignable to " + clazz);
        }
    }

    public static void state(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static void state(boolean bl) {
        Assert.state(bl, "[Assertion failed] - this state invariant must be true");
    }
}

