/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class ObjectUtils {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean isCheckedException(Throwable throwable) {
        return !(throwable instanceof RuntimeException) && !(throwable instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable throwable, Class[] classArray) {
        if (!ObjectUtils.isCheckedException(throwable)) {
            return true;
        }
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isAssignableFrom(throwable.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static Object[] addObjectToArray(Object[] objectArray, Object object) {
        Class clazz;
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = ObjectUtils.class$("java.lang.Object")) : class$java$lang$Object;
        if (objectArray != null) {
            clazz = objectArray.getClass().getComponentType();
        } else if (object != null) {
            clazz = object.getClass();
        }
        int n = objectArray != null ? objectArray.length + 1 : 1;
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        }
        objectArray2[objectArray2.length - 1] = object;
        return objectArray2;
    }

    public static Object[] toObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object == null) {
            return new Object[0];
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + object);
        }
        int n = Array.getLength(object);
        if (n == 0) {
            return new Object[0];
        }
        Class<?> clazz = Array.get(object, 0).getClass();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = Array.get(object, i);
        }
        return objectArray;
    }

    public static boolean nullSafeEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof short[] && object2 instanceof short[]) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        return false;
    }

    public static int nullSafeHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return ObjectUtils.nullSafeHashCode((Object[])object);
        }
        if (object instanceof boolean[]) {
            return ObjectUtils.nullSafeHashCode((boolean[])object);
        }
        if (object instanceof byte[]) {
            return ObjectUtils.nullSafeHashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return ObjectUtils.nullSafeHashCode((char[])object);
        }
        if (object instanceof double[]) {
            return ObjectUtils.nullSafeHashCode((double[])object);
        }
        if (object instanceof float[]) {
            return ObjectUtils.nullSafeHashCode((float[])object);
        }
        if (object instanceof int[]) {
            return ObjectUtils.nullSafeHashCode((int[])object);
        }
        if (object instanceof long[]) {
            return ObjectUtils.nullSafeHashCode((long[])object);
        }
        if (object instanceof short[]) {
            return ObjectUtils.nullSafeHashCode((short[])object);
        }
        return object.hashCode();
    }

    public static int nullSafeHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + ObjectUtils.nullSafeHashCode(objectArray[i]);
        }
        return n;
    }

    public static int nullSafeHashCode(boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = blArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + ObjectUtils.hashCode(blArray[i]);
        }
        return n;
    }

    public static int nullSafeHashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + byArray[i];
        }
        return n;
    }

    public static int nullSafeHashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + cArray[i];
        }
        return n;
    }

    public static int nullSafeHashCode(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + ObjectUtils.hashCode(dArray[i]);
        }
        return n;
    }

    public static int nullSafeHashCode(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + ObjectUtils.hashCode(fArray[i]);
        }
        return n;
    }

    public static int nullSafeHashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + nArray[i];
        }
        return n;
    }

    public static int nullSafeHashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = lArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + ObjectUtils.hashCode(lArray[i]);
        }
        return n;
    }

    public static int nullSafeHashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = 7;
        int n2 = sArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + sArray[i];
        }
        return n;
    }

    public static int hashCode(boolean bl) {
        return bl ? 1231 : 1237;
    }

    public static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return ObjectUtils.hashCode(l);
    }

    public static int hashCode(float f) {
        return Float.floatToIntBits(f);
    }

    public static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return EMPTY_STRING;
        }
        return object.getClass().getName() + "@" + ObjectUtils.getIdentityHexString(object);
    }

    public static String getIdentityHexString(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    public static String getDisplayString(Object object) {
        if (object == null) {
            return EMPTY_STRING;
        }
        return ObjectUtils.nullSafeToString(object);
    }

    public static String nullSafeClassName(Object object) {
        return object != null ? object.getClass().getName() : NULL_STRING;
    }

    public static String nullSafeToString(Object object) {
        if (object == null) {
            return NULL_STRING;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Object[]) {
            return ObjectUtils.nullSafeToString((Object[])object);
        }
        if (object instanceof boolean[]) {
            return ObjectUtils.nullSafeToString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return ObjectUtils.nullSafeToString((byte[])object);
        }
        if (object instanceof char[]) {
            return ObjectUtils.nullSafeToString((char[])object);
        }
        if (object instanceof double[]) {
            return ObjectUtils.nullSafeToString((double[])object);
        }
        if (object instanceof float[]) {
            return ObjectUtils.nullSafeToString((float[])object);
        }
        if (object instanceof int[]) {
            return ObjectUtils.nullSafeToString((int[])object);
        }
        if (object instanceof long[]) {
            return ObjectUtils.nullSafeToString((long[])object);
        }
        if (object instanceof short[]) {
            return ObjectUtils.nullSafeToString((short[])object);
        }
        String string = object.toString();
        return string != null ? string : EMPTY_STRING;
    }

    public static String nullSafeToString(Object[] objectArray) {
        if (objectArray == null) {
            return NULL_STRING;
        }
        int n = objectArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append(String.valueOf(objectArray[i]));
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    public static String nullSafeToString(boolean[] blArray) {
        if (blArray == null) {
            return NULL_STRING;
        }
        int n = blArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append(blArray[i]);
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    public static String nullSafeToString(byte[] byArray) {
        if (byArray == null) {
            return NULL_STRING;
        }
        int n = byArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append(byArray[i]);
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    public static String nullSafeToString(char[] cArray) {
        if (cArray == null) {
            return NULL_STRING;
        }
        int n = cArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append("'").append(cArray[i]).append("'");
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    public static String nullSafeToString(double[] dArray) {
        if (dArray == null) {
            return NULL_STRING;
        }
        int n = dArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append(dArray[i]);
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    public static String nullSafeToString(float[] fArray) {
        if (fArray == null) {
            return NULL_STRING;
        }
        int n = fArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append(fArray[i]);
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    public static String nullSafeToString(int[] nArray) {
        if (nArray == null) {
            return NULL_STRING;
        }
        int n = nArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    public static String nullSafeToString(long[] lArray) {
        if (lArray == null) {
            return NULL_STRING;
        }
        int n = lArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append(lArray[i]);
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    public static String nullSafeToString(short[] sArray) {
        if (sArray == null) {
            return NULL_STRING;
        }
        int n = sArray.length;
        if (n == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                stringBuffer.append(ARRAY_START);
            } else {
                stringBuffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            stringBuffer.append(sArray[i]);
        }
        stringBuffer.append(ARRAY_END);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

