/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.VerifyAccess;

final class MemberName
implements Member,
Cloneable {
    private Class<?> clazz;
    private String name;
    private Object type;
    private int flags;
    private Object resolution;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;
    static final String CONSTRUCTOR_NAME = "<init>";
    static final int RECOGNIZED_MODIFIERS = 65535;
    static final int IS_METHOD = 65536;
    static final int IS_CONSTRUCTOR = 131072;
    static final int IS_FIELD = 262144;
    static final int IS_TYPE = 524288;
    static final int IS_CALLER_SENSITIVE = 0x100000;
    static final int ALL_ACCESS = 7;
    static final int ALL_KINDS = 983040;
    static final int IS_INVOCABLE = 196608;
    static final int IS_FIELD_OR_METHOD = 327680;
    static final int SEARCH_ALL_SUPERS = 0x300000;

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public ClassLoader getClassLoader() {
        return this.clazz.getClassLoader();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.expandFromVM();
            if (this.name == null) {
                return null;
            }
        }
        return this.name;
    }

    public MethodType getMethodOrFieldType() {
        if (this.isInvocable()) {
            return this.getMethodType();
        }
        if (this.isGetter()) {
            return MethodType.methodType(this.getFieldType());
        }
        if (this.isSetter()) {
            return MethodType.methodType(Void.TYPE, this.getFieldType());
        }
        throw new InternalError("not a method or field: " + this);
    }

    public MethodType getMethodType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (!this.isInvocable()) {
            throw MethodHandleStatics.newIllegalArgumentException("not invocable, no method type");
        }
        if (this.type instanceof MethodType) {
            return (MethodType)this.type;
        }
        if (this.type instanceof String) {
            String string = (String)this.type;
            MethodType methodType = MethodType.fromMethodDescriptorString(string, this.getClassLoader());
            this.type = methodType;
            return methodType;
        }
        if (this.type instanceof Object[]) {
            Object[] objectArray = (Object[])this.type;
            Class[] classArray = (Class[])objectArray[1];
            Class clazz = (Class)objectArray[0];
            MethodType methodType = MethodType.methodType(clazz, classArray);
            this.type = methodType;
            return methodType;
        }
        throw new InternalError("bad method type " + this.type);
    }

    public MethodType getInvocationType() {
        MethodType methodType = this.getMethodOrFieldType();
        if (this.isConstructor() && this.getReferenceKind() == 8) {
            return methodType.changeReturnType(this.clazz);
        }
        if (!this.isStatic()) {
            return methodType.insertParameterTypes(0, this.clazz);
        }
        return methodType;
    }

    public Class<?>[] getParameterTypes() {
        return this.getMethodType().parameterArray();
    }

    public Class<?> getReturnType() {
        return this.getMethodType().returnType();
    }

    public Class<?> getFieldType() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.isInvocable()) {
            throw MethodHandleStatics.newIllegalArgumentException("not a field or nested class, no simple type");
        }
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof String) {
            Class<?> clazz;
            String string = (String)this.type;
            MethodType methodType = MethodType.fromMethodDescriptorString("()" + string, this.getClassLoader());
            this.type = clazz = methodType.returnType();
            return clazz;
        }
        throw new InternalError("bad field type " + this.type);
    }

    public Object getType() {
        return this.isInvocable() ? this.getMethodType() : this.getFieldType();
    }

    public String getSignature() {
        if (this.type == null) {
            this.expandFromVM();
            if (this.type == null) {
                return null;
            }
        }
        if (this.type instanceof String) {
            return (String)this.type;
        }
        if (this.isInvocable()) {
            return BytecodeDescriptor.unparse(this.getMethodType());
        }
        return BytecodeDescriptor.unparse(this.getFieldType());
    }

    @Override
    public int getModifiers() {
        return this.flags & 0xFFFF;
    }

    public byte getReferenceKind() {
        return (byte)(this.flags >>> 24 & 0xF);
    }

    private boolean referenceKindIsConsistent() {
        byte by = this.getReferenceKind();
        if (by == 0) {
            return this.isType();
        }
        if (this.isField()) {
            assert (this.staticIsConsistent());
            assert (MethodHandleNatives.refKindIsField(by));
        } else if (this.isConstructor()) {
            assert (by == 8 || by == 7);
        } else if (this.isMethod()) {
            assert (this.staticIsConsistent());
            assert (MethodHandleNatives.refKindIsMethod(by));
            if (this.clazz.isInterface()) assert (by == 9 || by == 5 && this.isObjectPublicMethod());
        } else assert (false);
        return true;
    }

    private boolean isObjectPublicMethod() {
        if (this.clazz == Object.class) {
            return true;
        }
        MethodType methodType = this.getMethodType();
        if (this.name.equals("toString") && methodType.returnType() == String.class && methodType.parameterCount() == 0) {
            return true;
        }
        if (this.name.equals("hashCode") && methodType.returnType() == Integer.TYPE && methodType.parameterCount() == 0) {
            return true;
        }
        return this.name.equals("equals") && methodType.returnType() == Boolean.TYPE && methodType.parameterCount() == 1 && methodType.parameterType(0) == Object.class;
    }

    boolean referenceKindIsConsistentWith(int n) {
        byte by = this.getReferenceKind();
        if (by == n) {
            return true;
        }
        switch (n) {
            case 9: {
                assert (by == 5 || by == 7) : this;
                return true;
            }
            case 5: 
            case 8: {
                assert (by == 7) : this;
                return true;
            }
        }
        assert (false) : this;
        return true;
    }

    private boolean staticIsConsistent() {
        byte by = this.getReferenceKind();
        return MethodHandleNatives.refKindIsStatic(by) == this.isStatic() || this.getModifiers() == 0;
    }

    private boolean vminfoIsConsistent() {
        byte by = this.getReferenceKind();
        assert (this.isResolved());
        Object object = MethodHandleNatives.getMemberVMInfo(this);
        assert (object instanceof Object[]);
        long l = (Long)((Object[])object)[0];
        Object object2 = ((Object[])object)[1];
        if (MethodHandleNatives.refKindIsField(by)) {
            assert (l >= 0L) : l + ":" + this;
            assert (object2 instanceof Class);
        } else {
            if (MethodHandleNatives.refKindDoesDispatch(by)) {
                assert (l >= 0L) : l + ":" + this;
            } else assert (l < 0L) : l;
            assert (object2 instanceof MemberName) : object2 + " in " + this;
        }
        return true;
    }

    private MemberName changeReferenceKind(byte by, byte by2) {
        assert (this.getReferenceKind() == by2);
        assert (MethodHandleNatives.refKindIsValid(by));
        this.flags += by - by2 << 24;
        return this;
    }

    private boolean testFlags(int n, int n2) {
        return (this.flags & n) == n2;
    }

    private boolean testAllFlags(int n) {
        return this.testFlags(n, n);
    }

    private boolean testAnyFlags(int n) {
        return !this.testFlags(n, 0);
    }

    public boolean isMethodHandleInvoke() {
        if (this.testFlags(280, 272) && this.clazz == MethodHandle.class) {
            return this.name.equals("invoke") || this.name.equals("invokeExact");
        }
        return false;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.flags);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.flags);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.flags);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.flags);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.flags);
    }

    public boolean canBeStaticallyBound() {
        return Modifier.isFinal(this.flags | this.clazz.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.flags);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.flags);
    }

    public boolean isNative() {
        return Modifier.isNative(this.flags);
    }

    public boolean isBridge() {
        return this.testAllFlags(65600);
    }

    public boolean isVarargs() {
        return this.testAllFlags(128) && this.isInvocable();
    }

    @Override
    public boolean isSynthetic() {
        return this.testAllFlags(4096);
    }

    public boolean isInvocable() {
        return this.testAnyFlags(196608);
    }

    public boolean isFieldOrMethod() {
        return this.testAnyFlags(327680);
    }

    public boolean isMethod() {
        return this.testAllFlags(65536);
    }

    public boolean isConstructor() {
        return this.testAllFlags(131072);
    }

    public boolean isField() {
        return this.testAllFlags(262144);
    }

    public boolean isType() {
        return this.testAllFlags(524288);
    }

    public boolean isPackage() {
        return !this.testAnyFlags(7);
    }

    public boolean isCallerSensitive() {
        return this.testAllFlags(0x100000);
    }

    public boolean isAccessibleFrom(Class<?> clazz) {
        return VerifyAccess.isMemberAccessible(this.getDeclaringClass(), this.getDeclaringClass(), this.flags, clazz, 15);
    }

    private void init(Class<?> clazz, String string, Object object, int n) {
        this.clazz = clazz;
        this.name = string;
        this.type = object;
        this.flags = n;
        assert (this.testAnyFlags(983040));
        assert (this.resolution == null);
    }

    private void expandFromVM() {
        if (!this.isResolved()) {
            return;
        }
        if (this.type instanceof Object[]) {
            this.type = null;
        }
        MethodHandleNatives.expand(this);
    }

    private static int flagsMods(int n, int n2, byte by) {
        assert ((n & 0xFFFF) == 0);
        assert ((n2 & 0xFFFF0000) == 0);
        assert ((by & 0xFFFFFFF0) == 0);
        return n | n2 | by << 24;
    }

    public MemberName(Method method) {
        this(method, false);
    }

    public MemberName(Method method, boolean bl) {
        method.getClass();
        MethodHandleNatives.init(this, method);
        assert (this.isResolved() && this.clazz != null);
        this.name = method.getName();
        if (this.type == null) {
            this.type = new Object[]{method.getReturnType(), method.getParameterTypes()};
        }
        if (bl && this.getReferenceKind() == 5) {
            this.changeReferenceKind((byte)7, (byte)5);
        }
    }

    public MemberName asSpecial() {
        switch (this.getReferenceKind()) {
            case 7: {
                return this;
            }
            case 5: {
                return this.clone().changeReferenceKind((byte)7, (byte)5);
            }
            case 8: {
                return this.clone().changeReferenceKind((byte)7, (byte)8);
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public MemberName asConstructor() {
        switch (this.getReferenceKind()) {
            case 7: {
                return this.clone().changeReferenceKind((byte)8, (byte)7);
            }
            case 8: {
                return this;
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public MemberName(Constructor<?> constructor) {
        constructor.getClass();
        MethodHandleNatives.init(this, constructor);
        assert (this.isResolved() && this.clazz != null);
        this.name = CONSTRUCTOR_NAME;
        if (this.type == null) {
            this.type = new Object[]{Void.TYPE, constructor.getParameterTypes()};
        }
    }

    public MemberName(Field field) {
        this(field, false);
    }

    public MemberName(Field field, boolean bl) {
        field.getClass();
        MethodHandleNatives.init(this, field);
        assert (this.isResolved() && this.clazz != null);
        this.name = field.getName();
        this.type = field.getType();
        byte by = this.getReferenceKind();
        assert (by == (this.isStatic() ? (byte)2 : 1));
        if (bl) {
            this.changeReferenceKind((byte)(by + 2), by);
        }
    }

    public boolean isGetter() {
        return MethodHandleNatives.refKindIsGetter(this.getReferenceKind());
    }

    public boolean isSetter() {
        return MethodHandleNatives.refKindIsSetter(this.getReferenceKind());
    }

    public MemberName asSetter() {
        byte by = this.getReferenceKind();
        assert (MethodHandleNatives.refKindIsGetter(by));
        byte by2 = (byte)(by + 2);
        return this.clone().changeReferenceKind(by2, by);
    }

    public MemberName(Class<?> clazz) {
        this.init(clazz.getDeclaringClass(), clazz.getSimpleName(), clazz, MemberName.flagsMods(524288, clazz.getModifiers(), (byte)0));
        this.initResolved(true);
    }

    MemberName() {
    }

    protected MemberName clone() {
        try {
            return (MemberName)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw MethodHandleStatics.newInternalError(cloneNotSupportedException);
        }
    }

    public MemberName getDefinition() {
        if (!this.isResolved()) {
            throw new IllegalStateException("must be resolved: " + this);
        }
        if (this.isType()) {
            return this;
        }
        MemberName memberName = this.clone();
        memberName.clazz = null;
        memberName.type = null;
        memberName.name = null;
        memberName.resolution = memberName;
        memberName.expandFromVM();
        assert (memberName.getName().equals(this.getName()));
        return memberName;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.flags, this.name, this.getType());
    }

    public boolean equals(Object object) {
        return object instanceof MemberName && this.equals((MemberName)object);
    }

    public boolean equals(MemberName memberName) {
        if (this == memberName) {
            return true;
        }
        if (memberName == null) {
            return false;
        }
        return this.clazz == memberName.clazz && this.flags == memberName.flags && Objects.equals(this.name, memberName.name) && Objects.equals(this.getType(), memberName.getType());
    }

    public MemberName(Class<?> clazz, String string, Class<?> clazz2, byte by) {
        this.init(clazz, string, clazz2, MemberName.flagsMods(262144, 0, by));
        this.initResolved(false);
    }

    public MemberName(Class<?> clazz, String string, Class<?> clazz2, Void void_) {
        this(clazz, string, clazz2, 0);
        this.initResolved(false);
    }

    public MemberName(Class<?> clazz, String string, MethodType methodType, byte by) {
        int n = string != null && string.equals(CONSTRUCTOR_NAME) ? 131072 : 65536;
        this.init(clazz, string, methodType, MemberName.flagsMods(n, 0, by));
        this.initResolved(false);
    }

    public boolean hasReceiverTypeDispatch() {
        return MethodHandleNatives.refKindDoesDispatch(this.getReferenceKind());
    }

    public boolean isResolved() {
        return this.resolution == null;
    }

    private void initResolved(boolean bl) {
        assert (this.resolution == null);
        if (!bl) {
            this.resolution = this;
        }
        assert (this.isResolved() == bl);
    }

    void checkForTypeAlias() {
        Class<?> clazz;
        if (this.isInvocable()) {
            MethodType methodType;
            if (this.type instanceof MethodType) {
                methodType = (MethodType)this.type;
            } else {
                methodType = this.getMethodType();
                this.type = methodType;
            }
            if (methodType.erase() == methodType) {
                return;
            }
            if (VerifyAccess.isTypeVisible(methodType, this.clazz)) {
                return;
            }
            throw new LinkageError("bad method type alias: " + methodType + " not visible from " + this.clazz);
        }
        if (this.type instanceof Class) {
            clazz = (Class<?>)this.type;
        } else {
            this.type = clazz = this.getFieldType();
        }
        if (VerifyAccess.isTypeVisible(clazz, this.clazz)) {
            return;
        }
        throw new LinkageError("bad field type alias: " + clazz + " not visible from " + this.clazz);
    }

    public String toString() {
        String string;
        if (this.isType()) {
            return this.type.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getDeclaringClass() != null) {
            stringBuilder.append(MemberName.getName(this.clazz));
            stringBuilder.append('.');
        }
        stringBuilder.append((string = this.getName()) == null ? "*" : string);
        Object object = this.getType();
        if (!this.isInvocable()) {
            stringBuilder.append('/');
            stringBuilder.append(object == null ? "*" : MemberName.getName(object));
        } else {
            stringBuilder.append(object == null ? "(*)*" : MemberName.getName(object));
        }
        byte by = this.getReferenceKind();
        if (by != 0) {
            stringBuilder.append('/');
            stringBuilder.append(MethodHandleNatives.refKindName(by));
        }
        return stringBuilder.toString();
    }

    private static String getName(Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    public IllegalAccessException makeAccessException(String string, Object object) {
        string = string + ": " + this.toString();
        if (object != null) {
            string = string + ", from " + object;
        }
        return new IllegalAccessException(string);
    }

    private String message() {
        if (this.isResolved()) {
            return "no access";
        }
        if (this.isConstructor()) {
            return "no such constructor";
        }
        if (this.isMethod()) {
            return "no such method";
        }
        return "no such field";
    }

    public ReflectiveOperationException makeAccessException() {
        String string = this.message() + ": " + this.toString();
        ReflectiveOperationException reflectiveOperationException = this.isResolved() || !(this.resolution instanceof NoSuchMethodError) && !(this.resolution instanceof NoSuchFieldError) ? new IllegalAccessException(string) : (this.isConstructor() ? new NoSuchMethodException(string) : (this.isMethod() ? new NoSuchMethodException(string) : new NoSuchFieldException(string)));
        if (this.resolution instanceof Throwable) {
            reflectiveOperationException.initCause((Throwable)this.resolution);
        }
        return reflectiveOperationException;
    }

    static Factory getFactory() {
        return Factory.INSTANCE;
    }

    static class Factory {
        static Factory INSTANCE = new Factory();
        private static int ALLOWED_FLAGS = 983040;

        private Factory() {
        }

        List<MemberName> getMembers(Class<?> clazz, String string, Object object, int n, Class<?> clazz2) {
            n &= ALLOWED_FLAGS;
            String string2 = null;
            if (object != null) {
                string2 = BytecodeDescriptor.unparse(object);
                n = string2.startsWith("(") ? (n &= 0xFFF3FFFF) : (n &= 0xFFF4FFFF);
            }
            int n2 = string == null ? 10 : (object == null ? 4 : 1);
            MemberName[] memberNameArray = Factory.newMemberBuffer(n2);
            int n3 = 0;
            ArrayList<MemberName[]> arrayList = null;
            int n4 = 0;
            while (true) {
                if ((n4 = MethodHandleNatives.getMembers(clazz, string, string2, n, clazz2, n3, memberNameArray)) <= memberNameArray.length) {
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    break;
                }
                n3 += memberNameArray.length;
                int n5 = n4 - memberNameArray.length;
                if (arrayList == null) {
                    arrayList = new ArrayList<MemberName[]>(1);
                }
                arrayList.add(memberNameArray);
                int n6 = memberNameArray.length;
                n6 = Math.max(n6, n5);
                n6 = Math.max(n6, n3 / 4);
                memberNameArray = Factory.newMemberBuffer(Math.min(8192, n6));
            }
            ArrayList<MemberName> arrayList2 = new ArrayList<MemberName>(n3 += n4);
            if (arrayList != null) {
                for (MemberName[] object2 : arrayList) {
                    Collections.addAll(arrayList2, object2);
                }
            }
            arrayList2.addAll(Arrays.asList(memberNameArray).subList(0, n4));
            if (object != null && object != string2) {
                Iterator<MemberName> iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    MemberName memberName = iterator.next();
                    if (object.equals(memberName.getType())) continue;
                    iterator.remove();
                }
            }
            return arrayList2;
        }

        private MemberName resolve(byte by, MemberName memberName, Class<?> clazz) {
            MemberName memberName2 = memberName.clone();
            assert (by == memberName2.getReferenceKind());
            try {
                memberName2 = MethodHandleNatives.resolve(memberName2, clazz);
                memberName2.checkForTypeAlias();
                memberName2.resolution = null;
            }
            catch (LinkageError linkageError) {
                assert (!memberName2.isResolved());
                memberName2.resolution = linkageError;
                return memberName2;
            }
            assert (memberName2.referenceKindIsConsistent());
            memberName2.initResolved(true);
            assert (memberName2.vminfoIsConsistent());
            return memberName2;
        }

        public <NoSuchMemberException extends ReflectiveOperationException> MemberName resolveOrFail(byte by, MemberName memberName, Class<?> clazz, Class<NoSuchMemberException> clazz2) throws IllegalAccessException, NoSuchMemberException {
            MemberName memberName2 = this.resolve(by, memberName, clazz);
            if (memberName2.isResolved()) {
                return memberName2;
            }
            ReflectiveOperationException reflectiveOperationException = memberName2.makeAccessException();
            if (reflectiveOperationException instanceof IllegalAccessException) {
                throw (IllegalAccessException)reflectiveOperationException;
            }
            throw (ReflectiveOperationException)clazz2.cast(reflectiveOperationException);
        }

        public MemberName resolveOrNull(byte by, MemberName memberName, Class<?> clazz) {
            MemberName memberName2 = this.resolve(by, memberName, clazz);
            if (memberName2.isResolved()) {
                return memberName2;
            }
            return null;
        }

        public List<MemberName> getMethods(Class<?> clazz, boolean bl, Class<?> clazz2) {
            return this.getMethods(clazz, bl, null, null, clazz2);
        }

        public List<MemberName> getMethods(Class<?> clazz, boolean bl, String string, MethodType methodType, Class<?> clazz2) {
            int n = 0x10000 | (bl ? 0x300000 : 0);
            return this.getMembers(clazz, string, methodType, n, clazz2);
        }

        public List<MemberName> getConstructors(Class<?> clazz, Class<?> clazz2) {
            return this.getMembers(clazz, null, null, 131072, clazz2);
        }

        public List<MemberName> getFields(Class<?> clazz, boolean bl, Class<?> clazz2) {
            return this.getFields(clazz, bl, null, null, clazz2);
        }

        public List<MemberName> getFields(Class<?> clazz, boolean bl, String string, Class<?> clazz2, Class<?> clazz3) {
            int n = 0x40000 | (bl ? 0x300000 : 0);
            return this.getMembers(clazz, string, clazz2, n, clazz3);
        }

        public List<MemberName> getNestedTypes(Class<?> clazz, boolean bl, Class<?> clazz2) {
            int n = 0x80000 | (bl ? 0x300000 : 0);
            return this.getMembers(clazz, null, null, n, clazz2);
        }

        private static MemberName[] newMemberBuffer(int n) {
            MemberName[] memberNameArray = new MemberName[n];
            for (int i = 0; i < n; ++i) {
                memberNameArray[i] = new MemberName();
            }
            return memberNameArray;
        }
    }
}

