/*
 * Decompiled with CFR 0.152.
 */
package java.util;

class ComparableTimSort {
    private static final int MIN_MERGE = 32;
    private final Object[] a;
    private static final int MIN_GALLOP = 7;
    private int minGallop = 7;
    private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
    private Object[] tmp;
    private int stackSize = 0;
    private final int[] runBase;
    private final int[] runLen;

    private ComparableTimSort(Object[] objectArray) {
        this.a = objectArray;
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n < 512 ? n >>> 1 : 256];
        this.tmp = objectArray2;
        int n2 = n < 120 ? 5 : (n < 1542 ? 10 : (n < 119151 ? 24 : 40));
        this.runBase = new int[n2];
        this.runLen = new int[n2];
    }

    static void sort(Object[] objectArray) {
        ComparableTimSort.sort(objectArray, 0, objectArray.length);
    }

    static void sort(Object[] objectArray, int n, int n2) {
        int n3;
        ComparableTimSort.rangeCheck(objectArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 < 2) {
            return;
        }
        if (n4 < 32) {
            int n5 = ComparableTimSort.countRunAndMakeAscending(objectArray, n, n2);
            ComparableTimSort.binarySort(objectArray, n, n2, n + n5);
            return;
        }
        ComparableTimSort comparableTimSort = new ComparableTimSort(objectArray);
        int n6 = ComparableTimSort.minRunLength(n4);
        do {
            if ((n3 = ComparableTimSort.countRunAndMakeAscending(objectArray, n, n2)) < n6) {
                int n7 = n4 <= n6 ? n4 : n6;
                ComparableTimSort.binarySort(objectArray, n, n + n7, n + n3);
                n3 = n7;
            }
            comparableTimSort.pushRun(n, n3);
            comparableTimSort.mergeCollapse();
            n += n3;
        } while ((n4 -= n3) != 0);
        assert (n == n2);
        comparableTimSort.mergeForceCollapse();
        assert (comparableTimSort.stackSize == 1);
    }

    private static void binarySort(Object[] objectArray, int n, int n2, int n3) {
        assert (n <= n3 && n3 <= n2);
        if (n3 == n) {
            ++n3;
        }
        while (n3 < n2) {
            int n4;
            Comparable comparable = (Comparable)objectArray[n3];
            int n5 = n;
            int n6 = n3;
            assert (n5 <= n6);
            while (n5 < n6) {
                n4 = n5 + n6 >>> 1;
                if (comparable.compareTo(objectArray[n4]) < 0) {
                    n6 = n4;
                    continue;
                }
                n5 = n4 + 1;
            }
            assert (n5 == n6);
            n4 = n3 - n5;
            switch (n4) {
                case 2: {
                    objectArray[n5 + 2] = objectArray[n5 + 1];
                }
                case 1: {
                    objectArray[n5 + 1] = objectArray[n5];
                    break;
                }
                default: {
                    System.arraycopy(objectArray, n5, objectArray, n5 + 1, n4);
                }
            }
            objectArray[n5] = comparable;
            ++n3;
        }
    }

    private static int countRunAndMakeAscending(Object[] objectArray, int n, int n2) {
        assert (n < n2);
        int n3 = n + 1;
        if (n3 == n2) {
            return 1;
        }
        if (((Comparable)objectArray[n3++]).compareTo(objectArray[n]) < 0) {
            while (n3 < n2 && ((Comparable)objectArray[n3]).compareTo(objectArray[n3 - 1]) < 0) {
                ++n3;
            }
            ComparableTimSort.reverseRange(objectArray, n, n3);
        } else {
            while (n3 < n2 && ((Comparable)objectArray[n3]).compareTo(objectArray[n3 - 1]) >= 0) {
                ++n3;
            }
        }
        return n3 - n;
    }

    private static void reverseRange(Object[] objectArray, int n, int n2) {
        --n2;
        while (n < n2) {
            Object object = objectArray[n];
            objectArray[n++] = objectArray[n2];
            objectArray[n2--] = object;
        }
    }

    private static int minRunLength(int n) {
        assert (n >= 0);
        int n2 = 0;
        while (n >= 32) {
            n2 |= n & 1;
            n >>= 1;
        }
        return n + n2;
    }

    private void pushRun(int n, int n2) {
        this.runBase[this.stackSize] = n;
        this.runLen[this.stackSize] = n2;
        ++this.stackSize;
    }

    private void mergeCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] <= this.runLen[n] + this.runLen[n + 1]) {
                if (this.runLen[n - 1] < this.runLen[n + 1]) {
                    --n;
                }
                this.mergeAt(n);
                continue;
            }
            if (this.runLen[n] > this.runLen[n + 1]) break;
            this.mergeAt(n);
        }
    }

    private void mergeForceCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] < this.runLen[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    private void mergeAt(int n) {
        assert (this.stackSize >= 2);
        assert (n >= 0);
        assert (n == this.stackSize - 2 || n == this.stackSize - 3);
        int n2 = this.runBase[n];
        int n3 = this.runLen[n];
        int n4 = this.runBase[n + 1];
        int n5 = this.runLen[n + 1];
        assert (n3 > 0 && n5 > 0);
        assert (n2 + n3 == n4);
        this.runLen[n] = n3 + n5;
        if (n == this.stackSize - 3) {
            this.runBase[n + 1] = this.runBase[n + 2];
            this.runLen[n + 1] = this.runLen[n + 2];
        }
        --this.stackSize;
        int n6 = ComparableTimSort.gallopRight((Comparable)this.a[n4], this.a, n2, n3, 0);
        assert (n6 >= 0);
        n2 += n6;
        if ((n3 -= n6) == 0) {
            return;
        }
        n5 = ComparableTimSort.gallopLeft((Comparable)this.a[n2 + n3 - 1], this.a, n4, n5, n5 - 1);
        assert (n5 >= 0);
        if (n5 == 0) {
            return;
        }
        if (n3 <= n5) {
            this.mergeLo(n2, n3, n4, n5);
        } else {
            this.mergeHi(n2, n3, n4, n5);
        }
    }

    private static int gallopLeft(Comparable<Object> comparable, Object[] objectArray, int n, int n2, int n3) {
        int n4;
        assert (n2 > 0 && n3 >= 0 && n3 < n2);
        int n5 = 0;
        int n6 = 1;
        if (comparable.compareTo(objectArray[n + n3]) > 0) {
            n4 = n2 - n3;
            while (n6 < n4 && comparable.compareTo(objectArray[n + n3 + n6]) > 0) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n4;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            n5 += n3;
            n6 += n3;
        } else {
            n4 = n3 + 1;
            while (n6 < n4 && comparable.compareTo(objectArray[n + n3 - n6]) <= 0) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n4;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            int n7 = n5;
            n5 = n3 - n6;
            n6 = n3 - n7;
        }
        assert (-1 <= n5 && n5 < n6 && n6 <= n2);
        ++n5;
        while (n5 < n6) {
            n4 = n5 + (n6 - n5 >>> 1);
            if (comparable.compareTo(objectArray[n + n4]) > 0) {
                n5 = n4 + 1;
                continue;
            }
            n6 = n4;
        }
        assert (n5 == n6);
        return n6;
    }

    private static int gallopRight(Comparable<Object> comparable, Object[] objectArray, int n, int n2, int n3) {
        int n4;
        assert (n2 > 0 && n3 >= 0 && n3 < n2);
        int n5 = 1;
        int n6 = 0;
        if (comparable.compareTo(objectArray[n + n3]) < 0) {
            n4 = n3 + 1;
            while (n5 < n4 && comparable.compareTo(objectArray[n + n3 - n5]) < 0) {
                n6 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n4;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            int n7 = n6;
            n6 = n3 - n5;
            n5 = n3 - n7;
        } else {
            n4 = n2 - n3;
            while (n5 < n4 && comparable.compareTo(objectArray[n + n3 + n5]) >= 0) {
                n6 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n4;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            n6 += n3;
            n5 += n3;
        }
        assert (-1 <= n6 && n6 < n5 && n5 <= n2);
        ++n6;
        while (n6 < n5) {
            n4 = n6 + (n5 - n6 >>> 1);
            if (comparable.compareTo(objectArray[n + n4]) < 0) {
                n5 = n4;
                continue;
            }
            n6 = n4 + 1;
        }
        assert (n6 == n5);
        return n5;
    }

    private void mergeLo(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        Object[] objectArray = this.a;
        Object[] objectArray2 = this.ensureCapacity(n2);
        System.arraycopy(objectArray, n, objectArray2, 0, n2);
        int n5 = 0;
        int n6 = n3;
        int n7 = n;
        objectArray[n7++] = objectArray[n6++];
        if (--n4 == 0) {
            System.arraycopy(objectArray2, n5, objectArray, n7, n2);
            return;
        }
        if (n2 == 1) {
            System.arraycopy(objectArray, n6, objectArray, n7, n4);
            objectArray[n7 + n4] = objectArray2[n5];
            return;
        }
        int n8 = this.minGallop;
        block0: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 1 && n4 > 0);
                if (((Comparable)objectArray[n6]).compareTo(objectArray2[n5]) < 0) {
                    objectArray[n7++] = objectArray[n6++];
                    ++n10;
                    n9 = 0;
                    if (--n4 != 0) continue;
                    break block0;
                }
                objectArray[n7++] = objectArray2[n5++];
                ++n9;
                n10 = 0;
                if (--n2 == 1) break block0;
            } while ((n9 | n10) < n8);
            do {
                assert (n2 > 1 && n4 > 0);
                n9 = ComparableTimSort.gallopRight((Comparable)objectArray[n6], objectArray2, n5, n2, 0);
                if (n9 != 0) {
                    System.arraycopy(objectArray2, n5, objectArray, n7, n9);
                    n7 += n9;
                    n5 += n9;
                    if ((n2 -= n9) <= 1) break block0;
                }
                objectArray[n7++] = objectArray[n6++];
                if (--n4 == 0) break block0;
                n10 = ComparableTimSort.gallopLeft((Comparable)objectArray2[n5], objectArray, n6, n4, 0);
                if (n10 != 0) {
                    System.arraycopy(objectArray, n6, objectArray, n7, n10);
                    n7 += n10;
                    n6 += n10;
                    if ((n4 -= n10) == 0) break block0;
                }
                objectArray[n7++] = objectArray2[n5++];
                if (--n2 == 1) break block0;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            n8 += 2;
        }
        int n11 = this.minGallop = n8 < 1 ? 1 : n8;
        if (n2 == 1) {
            assert (n4 > 0);
            System.arraycopy(objectArray, n6, objectArray, n7, n4);
            objectArray[n7 + n4] = objectArray2[n5];
        } else {
            if (n2 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            assert (n4 == 0);
            assert (n2 > 1);
            System.arraycopy(objectArray2, n5, objectArray, n7, n2);
        }
    }

    private void mergeHi(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        Object[] objectArray = this.a;
        Object[] objectArray2 = this.ensureCapacity(n4);
        System.arraycopy(objectArray, n3, objectArray2, 0, n4);
        int n5 = n + n2 - 1;
        int n6 = n4 - 1;
        int n7 = n3 + n4 - 1;
        objectArray[n7--] = objectArray[n5--];
        if (--n2 == 0) {
            System.arraycopy(objectArray2, 0, objectArray, n7 - (n4 - 1), n4);
            return;
        }
        if (n4 == 1) {
            System.arraycopy(objectArray, (n5 -= n2) + 1, objectArray, (n7 -= n2) + 1, n2);
            objectArray[n7] = objectArray2[n6];
            return;
        }
        int n8 = this.minGallop;
        block0: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 0 && n4 > 1);
                if (((Comparable)objectArray2[n6]).compareTo(objectArray[n5]) < 0) {
                    objectArray[n7--] = objectArray[n5--];
                    ++n9;
                    n10 = 0;
                    if (--n2 != 0) continue;
                    break block0;
                }
                objectArray[n7--] = objectArray2[n6--];
                ++n10;
                n9 = 0;
                if (--n4 == 1) break block0;
            } while ((n9 | n10) < n8);
            do {
                assert (n2 > 0 && n4 > 1);
                n9 = n2 - ComparableTimSort.gallopRight((Comparable)objectArray2[n6], objectArray, n, n2, n2 - 1);
                if (n9 != 0) {
                    System.arraycopy(objectArray, (n5 -= n9) + 1, objectArray, (n7 -= n9) + 1, n9);
                    if ((n2 -= n9) == 0) break block0;
                }
                objectArray[n7--] = objectArray2[n6--];
                if (--n4 == 1) break block0;
                n10 = n4 - ComparableTimSort.gallopLeft((Comparable)objectArray[n5], objectArray2, 0, n4, n4 - 1);
                if (n10 != 0) {
                    System.arraycopy(objectArray2, (n6 -= n10) + 1, objectArray, (n7 -= n10) + 1, n10);
                    if ((n4 -= n10) <= 1) break block0;
                }
                objectArray[n7--] = objectArray[n5--];
                if (--n2 == 0) break block0;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            n8 += 2;
        }
        int n11 = this.minGallop = n8 < 1 ? 1 : n8;
        if (n4 == 1) {
            assert (n2 > 0);
            System.arraycopy(objectArray, (n5 -= n2) + 1, objectArray, (n7 -= n2) + 1, n2);
            objectArray[n7] = objectArray2[n6];
        } else {
            if (n4 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            assert (n2 == 0);
            assert (n4 > 0);
            System.arraycopy(objectArray2, 0, objectArray, n7 - (n4 - 1), n4);
        }
    }

    private Object[] ensureCapacity(int n) {
        if (this.tmp.length < n) {
            int n2 = n;
            n2 |= n2 >> 1;
            n2 |= n2 >> 2;
            n2 |= n2 >> 4;
            n2 |= n2 >> 8;
            n2 |= n2 >> 16;
            n2 = ++n2 < 0 ? n : Math.min(n2, this.a.length >>> 1);
            Object[] objectArray = new Object[n2];
            this.tmp = objectArray;
        }
        return this.tmp;
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }
}

