/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.awt.Adjustable;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.apache.log4j.lf5.viewer.TrackingAdjustmentListener;

public class LF5SwingUtils {
    public static void selectRow(int n, JTable jTable, JScrollPane jScrollPane) {
        if (jTable == null || jScrollPane == null) {
            return;
        }
        if (!LF5SwingUtils.contains(n, jTable.getModel())) {
            return;
        }
        LF5SwingUtils.moveAdjustable(n * jTable.getRowHeight(), jScrollPane.getVerticalScrollBar());
        LF5SwingUtils.selectRow(n, jTable.getSelectionModel());
        LF5SwingUtils.repaintLater(jTable);
    }

    public static void makeScrollBarTrack(Adjustable adjustable) {
        if (adjustable == null) {
            return;
        }
        adjustable.addAdjustmentListener(new TrackingAdjustmentListener());
    }

    public static void makeVerticalScrollBarTrack(JScrollPane jScrollPane) {
        if (jScrollPane == null) {
            return;
        }
        LF5SwingUtils.makeScrollBarTrack(jScrollPane.getVerticalScrollBar());
    }

    protected static boolean contains(int n, TableModel tableModel) {
        if (tableModel == null) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        return n < tableModel.getRowCount();
    }

    protected static void selectRow(int n, ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            return;
        }
        listSelectionModel.setSelectionInterval(n, n);
    }

    protected static void moveAdjustable(int n, Adjustable adjustable) {
        if (adjustable == null) {
            return;
        }
        adjustable.setValue(n);
    }

    protected static void repaintLater(final JComponent jComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jComponent.repaint();
            }
        });
    }
}

