/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.ModbusSlaveException;
import net.wimpi.modbus.io.ModbusTransaction;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.TCPMasterConnection;
import net.wimpi.modbus.util.AtomicCounter;
import net.wimpi.modbus.util.Mutex;

public class ModbusTCPTransaction
implements ModbusTransaction {
    private static AtomicCounter c_TransactionID = new AtomicCounter(0);
    private TCPMasterConnection m_Connection;
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private boolean m_Reconnecting = false;
    private int m_Retries = 3;
    private Mutex m_TransactionLock = new Mutex();

    public ModbusTCPTransaction() {
    }

    public ModbusTCPTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusTCPTransaction(TCPMasterConnection con) {
        this.setConnection(con);
    }

    public void setConnection(TCPMasterConnection con) {
        this.m_Connection = con;
        this.m_IO = con.getModbusTransport();
    }

    @Override
    public void setRequest(ModbusRequest req) {
        this.m_Request = req;
    }

    @Override
    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    @Override
    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    @Override
    public int getTransactionID() {
        return c_TransactionID.get();
    }

    @Override
    public void setCheckingValidity(boolean b) {
        this.m_ValidityCheck = b;
    }

    @Override
    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    public void setReconnecting(boolean b) {
        this.m_Reconnecting = b;
    }

    public boolean isReconnecting() {
        return this.m_Reconnecting;
    }

    @Override
    public int getRetries() {
        return this.m_Retries;
    }

    @Override
    public void setRetries(int num) {
        this.m_Retries = num;
    }

    @Override
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        try {
            try {
                this.m_TransactionLock.acquire();
                if (!this.m_Connection.isConnected()) {
                    try {
                        this.m_Connection.connect();
                        this.m_IO = this.m_Connection.getModbusTransport();
                    }
                    catch (Exception ex) {
                        throw new ModbusIOException("Connecting failed.");
                    }
                }
                int retryCounter = 0;
                while (retryCounter <= this.m_Retries) {
                    try {
                        this.m_Request.setTransactionID(c_TransactionID.increment());
                        this.m_IO.writeMessage(this.m_Request);
                        this.m_Response = this.m_IO.readResponse();
                        break;
                    }
                    catch (ModbusIOException ex) {
                        if (retryCounter == this.m_Retries) {
                            throw new ModbusIOException("Executing transaction failed (tried " + this.m_Retries + " times)");
                        }
                        ++retryCounter;
                    }
                }
                if (this.m_Response instanceof ExceptionResponse) {
                    throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
                }
                if (this.isReconnecting()) {
                    this.m_Connection.close();
                }
                if (this.isCheckingValidity()) {
                    this.checkValidity();
                }
            }
            catch (InterruptedException ex) {
                throw new ModbusIOException("Thread acquiring lock was interrupted.");
            }
        }
        finally {
            this.m_TransactionLock.release();
        }
    }

    private void assertExecutable() throws ModbusException {
        if (this.m_Request == null || this.m_Connection == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    protected void checkValidity() throws ModbusException {
    }
}

