/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.util.SerialParameters;

public class ModbusSerialListener {
    private boolean m_Listening;
    private SerialConnection m_SerialCon;
    private static int c_RequestCounter = 0;
    private static final int REQUESTS_TOGC = 15;

    public ModbusSerialListener(SerialParameters params) {
        this.m_SerialCon = new SerialConnection(params);
        this.listen();
    }

    private void listen() {
        try {
            this.m_Listening = true;
            this.m_SerialCon.open();
            ModbusTransport transport = this.m_SerialCon.getModbusTransport();
            while (true) {
                if (!this.m_Listening) {
                    continue;
                }
                try {
                    ModbusRequest request = transport.readRequest();
                    ModbusResponse response = null;
                    response = ModbusCoupler.getReference().getProcessImage() == null ? request.createExceptionResponse(1) : request.createResponse();
                    if (Modbus.debug) {
                        System.out.println("Request:" + request.getHexMessage());
                    }
                    if (Modbus.debug) {
                        System.out.println("Response:" + response.getHexMessage());
                    }
                    transport.writeMessage(response);
                    this.count();
                }
                catch (ModbusIOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void setListening(boolean b) {
        this.m_Listening = b;
    }

    public boolean isListening() {
        return this.m_Listening;
    }

    private void count() {
        if (++c_RequestCounter == 15) {
            System.gc();
            c_RequestCounter = 0;
        }
    }
}

