/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharacterEditor;
import org.springframework.beans.propertyeditors.ClassArrayEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomMapEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.beans.propertyeditors.PatternEditor;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.beans.propertyeditors.URIEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.JdkVersion;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.springframework.util.ClassUtils;

public class PropertyEditorRegistrySupport
implements PropertyEditorRegistry {
    private boolean defaultEditorsActive = false;
    private boolean configValueEditorsActive = false;
    private boolean propertySpecificEditorsRegistered = false;
    private Map defaultEditors;
    private Map customEditors;
    private Set sharedEditors;
    private Map customEditorCache;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class array$Ljava$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class array$Lorg$springframework$core$io$Resource;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$util$regex$Pattern;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class array$Ljava$lang$String;

    protected void registerDefaultEditors() {
        this.defaultEditorsActive = true;
    }

    public void useConfigValueEditors() {
        this.configValueEditorsActive = true;
    }

    protected PropertyEditor getDefaultEditor(Class clazz) {
        if (!this.defaultEditorsActive) {
            return null;
        }
        if (this.defaultEditors == null) {
            this.doRegisterDefaultEditors();
        }
        return (PropertyEditor)this.defaultEditors.get(clazz);
    }

    private void doRegisterDefaultEditors() {
        this.defaultEditors = new HashMap(64);
        this.defaultEditors.put(class$java$lang$Class == null ? (class$java$lang$Class = PropertyEditorRegistrySupport.class$("java.lang.Class")) : class$java$lang$Class, new ClassEditor());
        this.defaultEditors.put(array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = PropertyEditorRegistrySupport.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class, new ClassArrayEditor());
        this.defaultEditors.put(class$java$io$File == null ? (class$java$io$File = PropertyEditorRegistrySupport.class$("java.io.File")) : class$java$io$File, new FileEditor());
        this.defaultEditors.put(class$java$io$InputStream == null ? (class$java$io$InputStream = PropertyEditorRegistrySupport.class$("java.io.InputStream")) : class$java$io$InputStream, new InputStreamEditor());
        this.defaultEditors.put(class$java$util$Locale == null ? (class$java$util$Locale = PropertyEditorRegistrySupport.class$("java.util.Locale")) : class$java$util$Locale, new LocaleEditor());
        this.defaultEditors.put(class$java$util$Properties == null ? (class$java$util$Properties = PropertyEditorRegistrySupport.class$("java.util.Properties")) : class$java$util$Properties, new PropertiesEditor());
        this.defaultEditors.put(array$Lorg$springframework$core$io$Resource == null ? (array$Lorg$springframework$core$io$Resource = PropertyEditorRegistrySupport.class$("[Lorg.springframework.core.io.Resource;")) : array$Lorg$springframework$core$io$Resource, new ResourceArrayPropertyEditor());
        this.defaultEditors.put(class$java$net$URL == null ? (class$java$net$URL = PropertyEditorRegistrySupport.class$("java.net.URL")) : class$java$net$URL, new URLEditor());
        if (JdkVersion.isAtLeastJava14()) {
            this.defaultEditors.put(class$java$net$URI == null ? (class$java$net$URI = PropertyEditorRegistrySupport.class$("java.net.URI")) : class$java$net$URI, new URIEditor());
            this.defaultEditors.put(class$java$util$regex$Pattern == null ? (class$java$util$regex$Pattern = PropertyEditorRegistrySupport.class$("java.util.regex.Pattern")) : class$java$util$regex$Pattern, new PatternEditor());
        }
        this.defaultEditors.put(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection, new CustomCollectionEditor(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection));
        this.defaultEditors.put(class$java$util$Set == null ? (class$java$util$Set = PropertyEditorRegistrySupport.class$("java.util.Set")) : class$java$util$Set, new CustomCollectionEditor(class$java$util$Set == null ? (class$java$util$Set = PropertyEditorRegistrySupport.class$("java.util.Set")) : class$java$util$Set));
        this.defaultEditors.put(class$java$util$SortedSet == null ? (class$java$util$SortedSet = PropertyEditorRegistrySupport.class$("java.util.SortedSet")) : class$java$util$SortedSet, new CustomCollectionEditor(class$java$util$SortedSet == null ? (class$java$util$SortedSet = PropertyEditorRegistrySupport.class$("java.util.SortedSet")) : class$java$util$SortedSet));
        this.defaultEditors.put(class$java$util$List == null ? (class$java$util$List = PropertyEditorRegistrySupport.class$("java.util.List")) : class$java$util$List, new CustomCollectionEditor(class$java$util$List == null ? (class$java$util$List = PropertyEditorRegistrySupport.class$("java.util.List")) : class$java$util$List));
        this.defaultEditors.put(class$java$util$SortedMap == null ? (class$java$util$SortedMap = PropertyEditorRegistrySupport.class$("java.util.SortedMap")) : class$java$util$SortedMap, new CustomMapEditor(class$java$util$SortedMap == null ? (class$java$util$SortedMap = PropertyEditorRegistrySupport.class$("java.util.SortedMap")) : class$java$util$SortedMap));
        this.defaultEditors.put(array$B == null ? (array$B = PropertyEditorRegistrySupport.class$("[B")) : array$B, new ByteArrayPropertyEditor());
        this.defaultEditors.put(array$C == null ? (array$C = PropertyEditorRegistrySupport.class$("[C")) : array$C, new CharArrayPropertyEditor());
        this.defaultEditors.put(Character.TYPE, new CharacterEditor(false));
        this.defaultEditors.put(class$java$lang$Character == null ? (class$java$lang$Character = PropertyEditorRegistrySupport.class$("java.lang.Character")) : class$java$lang$Character, new CharacterEditor(true));
        this.defaultEditors.put(Boolean.TYPE, new CustomBooleanEditor(false));
        this.defaultEditors.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyEditorRegistrySupport.class$("java.lang.Boolean")) : class$java$lang$Boolean, new CustomBooleanEditor(true));
        this.defaultEditors.put(Byte.TYPE, new CustomNumberEditor(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyEditorRegistrySupport.class$("java.lang.Byte")) : class$java$lang$Byte, false));
        this.defaultEditors.put(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyEditorRegistrySupport.class$("java.lang.Byte")) : class$java$lang$Byte, new CustomNumberEditor(class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyEditorRegistrySupport.class$("java.lang.Byte")) : class$java$lang$Byte, true));
        this.defaultEditors.put(Short.TYPE, new CustomNumberEditor(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistrySupport.class$("java.lang.Short")) : class$java$lang$Short, false));
        this.defaultEditors.put(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistrySupport.class$("java.lang.Short")) : class$java$lang$Short, new CustomNumberEditor(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistrySupport.class$("java.lang.Short")) : class$java$lang$Short, true));
        this.defaultEditors.put(Integer.TYPE, new CustomNumberEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistrySupport.class$("java.lang.Integer")) : class$java$lang$Integer, false));
        this.defaultEditors.put(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistrySupport.class$("java.lang.Integer")) : class$java$lang$Integer, new CustomNumberEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistrySupport.class$("java.lang.Integer")) : class$java$lang$Integer, true));
        this.defaultEditors.put(Long.TYPE, new CustomNumberEditor(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistrySupport.class$("java.lang.Long")) : class$java$lang$Long, false));
        this.defaultEditors.put(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistrySupport.class$("java.lang.Long")) : class$java$lang$Long, new CustomNumberEditor(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistrySupport.class$("java.lang.Long")) : class$java$lang$Long, true));
        this.defaultEditors.put(Float.TYPE, new CustomNumberEditor(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistrySupport.class$("java.lang.Float")) : class$java$lang$Float, false));
        this.defaultEditors.put(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistrySupport.class$("java.lang.Float")) : class$java$lang$Float, new CustomNumberEditor(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistrySupport.class$("java.lang.Float")) : class$java$lang$Float, true));
        this.defaultEditors.put(Double.TYPE, new CustomNumberEditor(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistrySupport.class$("java.lang.Double")) : class$java$lang$Double, false));
        this.defaultEditors.put(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistrySupport.class$("java.lang.Double")) : class$java$lang$Double, new CustomNumberEditor(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistrySupport.class$("java.lang.Double")) : class$java$lang$Double, true));
        this.defaultEditors.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyEditorRegistrySupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new CustomNumberEditor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyEditorRegistrySupport.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, true));
        this.defaultEditors.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyEditorRegistrySupport.class$("java.math.BigInteger")) : class$java$math$BigInteger, new CustomNumberEditor(class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyEditorRegistrySupport.class$("java.math.BigInteger")) : class$java$math$BigInteger, true));
        if (this.configValueEditorsActive) {
            this.defaultEditors.put(array$Ljava$lang$String == null ? (array$Ljava$lang$String = PropertyEditorRegistrySupport.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, new StringArrayPropertyEditor());
        }
    }

    protected void copyDefaultEditorsTo(PropertyEditorRegistrySupport propertyEditorRegistrySupport) {
        propertyEditorRegistrySupport.defaultEditors = this.defaultEditors;
        propertyEditorRegistrySupport.defaultEditorsActive = this.defaultEditorsActive;
        propertyEditorRegistrySupport.configValueEditorsActive = this.configValueEditorsActive;
    }

    public void registerCustomEditor(Class clazz, PropertyEditor propertyEditor) {
        this.registerCustomEditor(clazz, null, propertyEditor);
    }

    public void registerCustomEditor(Class clazz, String string, PropertyEditor propertyEditor) {
        if (clazz == null && string == null) {
            throw new IllegalArgumentException("Either requiredType or propertyPath is required");
        }
        if (this.customEditors == null) {
            this.customEditors = CollectionFactory.createLinkedMapIfPossible((int)16);
        }
        if (string != null) {
            this.customEditors.put(string, new CustomEditorHolder(propertyEditor, clazz));
            this.propertySpecificEditorsRegistered = true;
        } else {
            this.customEditors.put(clazz, propertyEditor);
            this.customEditorCache = null;
        }
    }

    public void registerSharedEditor(Class clazz, PropertyEditor propertyEditor) {
        this.registerCustomEditor(clazz, null, propertyEditor);
        if (this.sharedEditors == null) {
            this.sharedEditors = new HashSet();
        }
        this.sharedEditors.add(propertyEditor);
    }

    public boolean isSharedEditor(PropertyEditor propertyEditor) {
        return this.sharedEditors != null && this.sharedEditors.contains(propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class clazz, String string) {
        if (this.customEditors == null) {
            return null;
        }
        Class clazz2 = clazz;
        if (string != null) {
            if (this.propertySpecificEditorsRegistered) {
                PropertyEditor propertyEditor = this.getCustomEditor(string, clazz);
                if (propertyEditor == null) {
                    LinkedList linkedList = new LinkedList();
                    this.addStrippedPropertyPaths(linkedList, "", string);
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext() && propertyEditor == null) {
                        String string2 = (String)iterator.next();
                        propertyEditor = this.getCustomEditor(string2, clazz);
                    }
                }
                if (propertyEditor != null) {
                    return propertyEditor;
                }
            }
            if (clazz == null) {
                clazz2 = this.getPropertyType(string);
            }
        }
        return this.getCustomEditor(clazz2);
    }

    public boolean hasCustomEditorForElement(Class clazz, String string) {
        if (this.customEditors == null) {
            return false;
        }
        if (string != null && this.propertySpecificEditorsRegistered) {
            Iterator iterator = this.customEditors.entrySet().iterator();
            while (iterator.hasNext()) {
                CustomEditorHolder customEditorHolder;
                String string2;
                Map.Entry entry = iterator.next();
                if (!(entry.getKey() instanceof String) || !PropertyAccessorUtils.matchesProperty(string2 = (String)entry.getKey(), string) || (customEditorHolder = (CustomEditorHolder)entry.getValue()).getPropertyEditor(clazz) == null) continue;
                return true;
            }
        }
        return clazz != null && this.customEditors.containsKey(clazz);
    }

    protected Class getPropertyType(String string) {
        return null;
    }

    private PropertyEditor getCustomEditor(String string, Class clazz) {
        CustomEditorHolder customEditorHolder = (CustomEditorHolder)this.customEditors.get(string);
        return customEditorHolder != null ? customEditorHolder.getPropertyEditor(clazz) : null;
    }

    private PropertyEditor getCustomEditor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        PropertyEditor propertyEditor = (PropertyEditor)this.customEditors.get(clazz);
        if (propertyEditor == null) {
            if (this.customEditorCache != null) {
                propertyEditor = (PropertyEditor)this.customEditorCache.get(clazz);
            }
            if (propertyEditor == null) {
                Iterator iterator = this.customEditors.keySet().iterator();
                while (iterator.hasNext() && propertyEditor == null) {
                    Object k = iterator.next();
                    if (!(k instanceof Class) || !((Class)k).isAssignableFrom(clazz)) continue;
                    propertyEditor = (PropertyEditor)this.customEditors.get(k);
                    if (this.customEditorCache == null) {
                        this.customEditorCache = new HashMap();
                    }
                    this.customEditorCache.put(clazz, propertyEditor);
                }
            }
        }
        return propertyEditor;
    }

    protected Class guessPropertyTypeFromEditors(String string) {
        if (this.customEditors != null) {
            CustomEditorHolder customEditorHolder = (CustomEditorHolder)this.customEditors.get(string);
            if (customEditorHolder == null) {
                LinkedList linkedList = new LinkedList();
                this.addStrippedPropertyPaths(linkedList, "", string);
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext() && customEditorHolder == null) {
                    String string2 = (String)iterator.next();
                    customEditorHolder = (CustomEditorHolder)this.customEditors.get(string2);
                }
            }
            if (customEditorHolder != null) {
                return customEditorHolder.getRegisteredType();
            }
        }
        return null;
    }

    protected void copyCustomEditorsTo(PropertyEditorRegistry propertyEditorRegistry, String string) {
        String string2;
        String string3 = string2 = string != null ? PropertyAccessorUtils.getPropertyName(string) : null;
        if (this.customEditors != null) {
            Iterator iterator = this.customEditors.entrySet().iterator();
            while (iterator.hasNext()) {
                int n;
                Object object;
                Map.Entry entry = iterator.next();
                if (entry.getKey() instanceof Class) {
                    object = (Class)entry.getKey();
                    PropertyEditor propertyEditor = (PropertyEditor)entry.getValue();
                    propertyEditorRegistry.registerCustomEditor((Class)object, propertyEditor);
                    continue;
                }
                if (!(entry.getKey() instanceof String & string != null) || (n = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)(object = (String)entry.getKey()))) == -1) continue;
                String string4 = ((String)object).substring(0, n);
                String string5 = ((String)object).substring(n + 1);
                if (!string4.equals(string) && !string4.equals(string2)) continue;
                CustomEditorHolder customEditorHolder = (CustomEditorHolder)entry.getValue();
                propertyEditorRegistry.registerCustomEditor(customEditorHolder.getRegisteredType(), string5, customEditorHolder.getPropertyEditor());
            }
        }
    }

    private void addStrippedPropertyPaths(List list, String string, String string2) {
        int n;
        int n2 = string2.indexOf(91);
        if (n2 != -1 && (n = string2.indexOf(93)) != -1) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2, n + 1);
            String string5 = string2.substring(n + 1, string2.length());
            list.add(string + string3 + string5);
            this.addStrippedPropertyPaths(list, string + string3, string5);
            this.addStrippedPropertyPaths(list, string + string3 + string4, string5);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CustomEditorHolder {
        private final PropertyEditor propertyEditor;
        private final Class registeredType;

        private CustomEditorHolder(PropertyEditor propertyEditor, Class clazz) {
            this.propertyEditor = propertyEditor;
            this.registeredType = clazz;
        }

        private PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        private Class getRegisteredType() {
            return this.registeredType;
        }

        private PropertyEditor getPropertyEditor(Class clazz) {
            if (this.registeredType == null || clazz != null && (ClassUtils.isAssignable((Class)this.registeredType, (Class)clazz) || ClassUtils.isAssignable((Class)clazz, (Class)this.registeredType)) || clazz == null && !(class$java$util$Collection == null ? (class$java$util$Collection = PropertyEditorRegistrySupport.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(this.registeredType) && !this.registeredType.isArray()) {
                return this.propertyEditor;
            }
            return null;
        }
    }
}

