/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.core.CollectionFactory;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class TypeConverterDelegate {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$TypeConverterDelegate == null ? (class$org$springframework$beans$TypeConverterDelegate = TypeConverterDelegate.class$("org.springframework.beans.TypeConverterDelegate")) : class$org$springframework$beans$TypeConverterDelegate));
    private static final Map unknownEditorTypes = Collections.synchronizedMap(new WeakHashMap());
    private final PropertyEditorRegistrySupport propertyEditorRegistry;
    private final Object targetObject;
    static /* synthetic */ Class class$org$springframework$beans$TypeConverterDelegate;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistrySupport) {
        this(propertyEditorRegistrySupport, null);
    }

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistrySupport, Object object) {
        this.propertyEditorRegistry = propertyEditorRegistrySupport;
        this.targetObject = object;
    }

    public Object convertIfNecessary(Object object, Class clazz) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, object, clazz, null, null);
    }

    public Object convertIfNecessary(Object object, Class clazz, MethodParameter methodParameter) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, object, clazz, null, methodParameter);
    }

    public Object convertIfNecessary(String string, Object object, Object object2, Class clazz) throws IllegalArgumentException {
        return this.convertIfNecessary(string, object, object2, clazz, null, null);
    }

    public Object convertIfNecessary(Object object, Object object2, PropertyDescriptor propertyDescriptor) throws IllegalArgumentException {
        return this.convertIfNecessary(propertyDescriptor.getName(), object, object2, propertyDescriptor.getPropertyType(), propertyDescriptor, new MethodParameter(propertyDescriptor.getWriteMethod(), 0));
    }

    protected Object convertIfNecessary(String string, Object object, Object object2, Class clazz, PropertyDescriptor propertyDescriptor, MethodParameter methodParameter) throws IllegalArgumentException {
        AnnotatedElement annotatedElement;
        Object object3 = object2;
        PropertyEditor propertyEditor = this.propertyEditorRegistry.findCustomEditor(clazz, string);
        if (propertyEditor != null || clazz != null && !ClassUtils.isAssignableValue((Class)clazz, (Object)object3)) {
            if (propertyEditor == null && propertyDescriptor != null) {
                if (JdkVersion.isAtLeastJava15()) {
                    propertyEditor = propertyDescriptor.createPropertyEditor(this.targetObject);
                } else {
                    annotatedElement = propertyDescriptor.getPropertyEditorClass();
                    if (annotatedElement != null) {
                        propertyEditor = (PropertyEditor)BeanUtils.instantiateClass(annotatedElement);
                    }
                }
            }
            if (propertyEditor == null && clazz != null && (propertyEditor = this.propertyEditorRegistry.getDefaultEditor(clazz)) == null && !unknownEditorTypes.containsKey(clazz) && (propertyEditor = PropertyEditorManager.findEditor(clazz)) == null) {
                unknownEditorTypes.put(clazz, Boolean.TRUE);
            }
            object3 = this.doConvertValue(object, object3, clazz, propertyEditor);
        }
        if (clazz != null) {
            block17: {
                if (object3 != null && clazz.isArray()) {
                    return this.convertToTypedArray(object3, string, clazz.getComponentType());
                }
                if (object3 instanceof Collection && (class$java$util$Collection == null ? (class$java$util$Collection = TypeConverterDelegate.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
                    object3 = this.convertToTypedCollection((Collection)object3, string, methodParameter);
                } else if (object3 instanceof Map && (class$java$util$Map == null ? (class$java$util$Map = TypeConverterDelegate.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
                    object3 = this.convertToTypedMap((Map)object3, string, methodParameter);
                } else if (object3 instanceof String && !clazz.isInstance(object3)) {
                    if (JdkVersion.isAtLeastJava15() && clazz.isEnum() && "".equals(object3)) {
                        return null;
                    }
                    try {
                        annotatedElement = clazz.getField((String)object3);
                        object3 = ((Field)annotatedElement).get(null);
                    }
                    catch (Throwable throwable) {
                        if (!logger.isTraceEnabled()) break block17;
                        logger.trace((Object)("Field [" + object3 + "] isn't an enum value"), throwable);
                    }
                }
            }
            if (!ClassUtils.isAssignableValue((Class)clazz, (Object)object3)) {
                throw new IllegalArgumentException("Cannot convert value of type [" + (object2 != null ? ClassUtils.getQualifiedName(object2.getClass()) : null) + "] to required type [" + ClassUtils.getQualifiedName((Class)clazz) + "] for property '" + string + "': no matching editors or conversion strategy found");
            }
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doConvertValue(Object object, Object object2, Class clazz, PropertyEditor propertyEditor) {
        PropertyEditor propertyEditor2;
        Object object3;
        Object object4 = object2;
        boolean bl = false;
        if (propertyEditor != null) {
            bl = this.propertyEditorRegistry.isSharedEditor(propertyEditor);
        }
        if (propertyEditor != null && !(object4 instanceof String)) {
            object3 = null;
            if (bl) {
                propertyEditor2 = propertyEditor;
                synchronized (propertyEditor2) {
                    propertyEditor.setValue(object4);
                    object3 = propertyEditor.getValue();
                }
            } else {
                propertyEditor.setValue(object4);
                object3 = propertyEditor.getValue();
            }
            if (object3 != object4) {
                object4 = object3;
                propertyEditor = null;
            }
        }
        if (clazz != null && !clazz.isArray() && object4 instanceof String[]) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Converting String array to comma-delimited String [" + object4 + "]"));
            }
            object4 = StringUtils.arrayToCommaDelimitedString((Object[])((String[])object4));
        }
        if (propertyEditor != null && object4 instanceof String) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Converting String to [" + clazz + "] using property editor [" + propertyEditor + "]"));
            }
            object3 = (String)object4;
            if (bl) {
                propertyEditor2 = propertyEditor;
                synchronized (propertyEditor2) {
                    return this.doConvertTextValue(object, (String)object3, propertyEditor);
                }
            }
            return this.doConvertTextValue(object, (String)object3, propertyEditor);
        }
        return object4;
    }

    protected Object doConvertTextValue(Object object, String string, PropertyEditor propertyEditor) {
        propertyEditor.setValue(object);
        propertyEditor.setAsText(string);
        return propertyEditor.getValue();
    }

    protected Object convertToTypedArray(Object object, String string, Class clazz) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Object object2 = Array.newInstance(clazz, collection.size());
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object3 = this.convertIfNecessary(this.buildIndexedPropertyName(string, n), null, iterator.next(), clazz);
                Array.set(object2, n, object3);
                ++n;
            }
            return object2;
        }
        if (object.getClass().isArray()) {
            if (clazz.equals(object.getClass().getComponentType()) && !this.propertyEditorRegistry.hasCustomEditorForElement(clazz, string)) {
                return object;
            }
            int n = Array.getLength(object);
            Object object4 = Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                Object object5 = this.convertIfNecessary(this.buildIndexedPropertyName(string, i), null, Array.get(object, i), clazz);
                Array.set(object4, i, object5);
            }
            return object4;
        }
        Object object6 = Array.newInstance(clazz, 1);
        Object object7 = this.convertIfNecessary(this.buildIndexedPropertyName(string, 0), null, object, clazz);
        Array.set(object6, 0, object7);
        return object6;
    }

    protected Collection convertToTypedCollection(Collection collection, String string, MethodParameter methodParameter) {
        Class clazz = null;
        if (methodParameter != null && JdkVersion.isAtLeastJava15()) {
            clazz = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)methodParameter);
        }
        if (clazz == null && !this.propertyEditorRegistry.hasCustomEditorForElement(null, string)) {
            return collection;
        }
        Collection collection2 = null;
        Iterator iterator = null;
        try {
            collection2 = CollectionFactory.createApproximateCollection((Object)collection, (int)collection.size());
            iterator = collection.iterator();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot access Collection of type [" + collection.getClass().getName() + "] - injecting original Collection as-is"), throwable);
            }
            return collection;
        }
        boolean bl = false;
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string2 = this.buildIndexedPropertyName(string, n);
            if (methodParameter != null) {
                methodParameter.increaseNestingLevel();
            }
            Object object = this.convertIfNecessary(string2, null, e, clazz, null, methodParameter);
            if (methodParameter != null) {
                methodParameter.decreaseNestingLevel();
            }
            collection2.add(object);
            bl = bl || e != object;
            ++n;
        }
        return bl ? collection2 : collection;
    }

    protected Map convertToTypedMap(Map map, String string, MethodParameter methodParameter) {
        Class clazz = null;
        Class clazz2 = null;
        if (methodParameter != null && JdkVersion.isAtLeastJava15()) {
            clazz = GenericCollectionTypeResolver.getMapKeyParameterType((MethodParameter)methodParameter);
            clazz2 = GenericCollectionTypeResolver.getMapValueParameterType((MethodParameter)methodParameter);
        }
        if (clazz == null && clazz2 == null && !this.propertyEditorRegistry.hasCustomEditorForElement(null, string)) {
            return map;
        }
        Map map2 = null;
        Iterator iterator = null;
        try {
            map2 = CollectionFactory.createApproximateMap((Object)map, (int)map.size());
            iterator = map.entrySet().iterator();
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cannot access Map of type [" + map.getClass().getName() + "] - injecting original Map as-is"), throwable);
            }
            return map;
        }
        boolean bl = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            String string2 = this.buildKeyedPropertyName(string, k);
            if (methodParameter != null) {
                methodParameter.increaseNestingLevel();
                methodParameter.setTypeIndexForCurrentLevel(0);
            }
            Object object = this.convertIfNecessary(string2, null, k, clazz, null, methodParameter);
            if (methodParameter != null) {
                methodParameter.setTypeIndexForCurrentLevel(1);
            }
            Object object2 = this.convertIfNecessary(string2, null, v, clazz2, null, methodParameter);
            if (methodParameter != null) {
                methodParameter.decreaseNestingLevel();
            }
            map2.put(object, object2);
            bl = bl || k != object || v != object2;
        }
        return bl ? map2 : map;
    }

    private String buildIndexedPropertyName(String string, int n) {
        return string != null ? string + "[" + n + "]" : null;
    }

    private String buildKeyedPropertyName(String string, Object object) {
        return string != null ? string + "[" + object + "]" : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

