/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class PreferencesPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    private String systemTreePath;
    private String userTreePath;
    private Preferences systemPrefs;
    private Preferences userPrefs;

    public void setSystemTreePath(String string) {
        this.systemTreePath = string;
    }

    public void setUserTreePath(String string) {
        this.userTreePath = string;
    }

    public void afterPropertiesSet() {
        this.systemPrefs = this.systemTreePath != null ? Preferences.systemRoot().node(this.systemTreePath) : Preferences.systemRoot();
        this.userPrefs = this.userTreePath != null ? Preferences.userRoot().node(this.userTreePath) : Preferences.userRoot();
    }

    protected String resolvePlaceholder(String string, Properties properties) {
        String string2;
        String string3 = null;
        String string4 = string;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if ((string2 = this.resolvePlaceholder(string3, string4, this.userPrefs)) == null && (string2 = this.resolvePlaceholder(string3, string4, this.systemPrefs)) == null) {
            string2 = properties.getProperty(string);
        }
        return string2;
    }

    protected String resolvePlaceholder(String string, String string2, Preferences preferences) {
        if (string != null) {
            try {
                if (preferences.nodeExists(string)) {
                    return preferences.node(string).get(string2, null);
                }
                return null;
            }
            catch (BackingStoreException backingStoreException) {
                throw new BeanDefinitionStoreException("Cannot access specified node path [" + string + "]", backingStoreException);
            }
        }
        return preferences.get(string2, null);
    }
}

