/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.parsing;

import org.springframework.beans.factory.parsing.AliasDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.DefaultsDefinition;
import org.springframework.beans.factory.parsing.ImportDefinition;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.ParseState;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.ReaderEventListener;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.core.io.Resource;

public class ReaderContext {
    private final Resource resource;
    private final ProblemReporter problemReporter;
    private final ReaderEventListener eventListener;
    private final SourceExtractor sourceExtractor;

    public ReaderContext(Resource resource, ProblemReporter problemReporter, ReaderEventListener readerEventListener, SourceExtractor sourceExtractor) {
        this.resource = resource;
        this.problemReporter = problemReporter;
        this.eventListener = readerEventListener;
        this.sourceExtractor = sourceExtractor;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public void fatal(String string, Object object) {
        this.fatal(string, object, null, null);
    }

    public void fatal(String string, Object object, Throwable throwable) {
        this.fatal(string, object, null, throwable);
    }

    public void fatal(String string, Object object, ParseState parseState) {
        this.fatal(string, object, parseState, null);
    }

    public void fatal(String string, Object object, ParseState parseState, Throwable throwable) {
        Location location = new Location(this.getResource(), object);
        this.problemReporter.fatal(new Problem(string, location, parseState, throwable));
    }

    public void error(String string, Object object) {
        this.error(string, object, null, null);
    }

    public void error(String string, Object object, Throwable throwable) {
        this.error(string, object, null, throwable);
    }

    public void error(String string, Object object, ParseState parseState) {
        this.error(string, object, parseState, null);
    }

    public void error(String string, Object object, ParseState parseState, Throwable throwable) {
        Location location = new Location(this.getResource(), object);
        this.problemReporter.error(new Problem(string, location, parseState, throwable));
    }

    public void warning(String string, Object object) {
        this.warning(string, object, null, null);
    }

    public void warning(String string, Object object, Throwable throwable) {
        this.warning(string, object, null, throwable);
    }

    public void warning(String string, Object object, ParseState parseState) {
        this.warning(string, object, parseState, null);
    }

    public void warning(String string, Object object, ParseState parseState, Throwable throwable) {
        Location location = new Location(this.getResource(), object);
        this.problemReporter.warning(new Problem(string, location, parseState, throwable));
    }

    public void fireDefaultsRegistered(DefaultsDefinition defaultsDefinition) {
        this.eventListener.defaultsRegistered(defaultsDefinition);
    }

    public void fireComponentRegistered(ComponentDefinition componentDefinition) {
        this.eventListener.componentRegistered(componentDefinition);
    }

    public void fireAliasRegistered(String string, String string2, Object object) {
        this.eventListener.aliasRegistered(new AliasDefinition(string, string2, object));
    }

    public void fireImportProcessed(String string, Object object) {
        this.eventListener.importProcessed(new ImportDefinition(string, object));
    }

    public SourceExtractor getSourceExtractor() {
        return this.sourceExtractor;
    }

    public Object extractSource(Object object) {
        return this.sourceExtractor.extractSource(object, this.resource);
    }
}

