/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.util.ObjectUtils;

public class ChildBeanDefinition
extends AbstractBeanDefinition {
    private final String parentName;

    public ChildBeanDefinition(String string) {
        this.parentName = string;
    }

    public ChildBeanDefinition(String string, MutablePropertyValues mutablePropertyValues) {
        super(null, mutablePropertyValues);
        this.parentName = string;
    }

    public ChildBeanDefinition(String string, ConstructorArgumentValues constructorArgumentValues, MutablePropertyValues mutablePropertyValues) {
        super(constructorArgumentValues, mutablePropertyValues);
        this.parentName = string;
    }

    public ChildBeanDefinition(String string, Class clazz, ConstructorArgumentValues constructorArgumentValues, MutablePropertyValues mutablePropertyValues) {
        super(constructorArgumentValues, mutablePropertyValues);
        this.parentName = string;
        this.setBeanClass(clazz);
    }

    public ChildBeanDefinition(String string, String string2, ConstructorArgumentValues constructorArgumentValues, MutablePropertyValues mutablePropertyValues) {
        super(constructorArgumentValues, mutablePropertyValues);
        this.parentName = string;
        this.setBeanClassName(string2);
    }

    public ChildBeanDefinition(ChildBeanDefinition childBeanDefinition) {
        super(childBeanDefinition);
        this.parentName = childBeanDefinition.getParentName();
    }

    public String getParentName() {
        return this.parentName;
    }

    public void validate() throws BeanDefinitionValidationException {
        super.validate();
        if (this.parentName == null) {
            throw new BeanDefinitionValidationException("'parentName' must be set in ChildBeanDefinition");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChildBeanDefinition)) {
            return false;
        }
        ChildBeanDefinition childBeanDefinition = (ChildBeanDefinition)object;
        return ObjectUtils.nullSafeEquals((Object)this.parentName, (Object)childBeanDefinition.parentName) && super.equals(object);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.parentName) * 29 + super.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Child bean with parent '");
        stringBuffer.append(this.parentName).append("': ").append(super.toString());
        return stringBuffer.toString();
    }
}

