/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.StringUtils;

public class SimpleInstantiationStrategy
implements InstantiationStrategy {
    public Object instantiate(RootBeanDefinition rootBeanDefinition, String string, BeanFactory beanFactory) {
        if (rootBeanDefinition.getMethodOverrides().isEmpty()) {
            Constructor constructor = (Constructor)rootBeanDefinition.resolvedConstructorOrFactoryMethod;
            if (constructor == null) {
                Class clazz = rootBeanDefinition.getBeanClass();
                if (clazz.isInterface()) {
                    throw new BeanInstantiationException(clazz, "Specified class is an interface");
                }
                try {
                    rootBeanDefinition.resolvedConstructorOrFactoryMethod = constructor = clazz.getDeclaredConstructor(null);
                }
                catch (Exception exception) {
                    throw new BeanInstantiationException(clazz, "No default constructor found", exception);
                }
            }
            return BeanUtils.instantiateClass(constructor, null);
        }
        return this.instantiateWithMethodInjection(rootBeanDefinition, string, beanFactory);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition rootBeanDefinition, String string, BeanFactory beanFactory) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    public Object instantiate(RootBeanDefinition rootBeanDefinition, String string, BeanFactory beanFactory, Constructor constructor, Object[] objectArray) {
        if (rootBeanDefinition.getMethodOverrides().isEmpty()) {
            return BeanUtils.instantiateClass(constructor, objectArray);
        }
        return this.instantiateWithMethodInjection(rootBeanDefinition, string, beanFactory, constructor, objectArray);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition rootBeanDefinition, String string, BeanFactory beanFactory, Constructor constructor, Object[] objectArray) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    public Object instantiate(RootBeanDefinition rootBeanDefinition, String string, BeanFactory beanFactory, Object object, Method method, Object[] objectArray) {
        try {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            return method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanDefinitionStoreException("Illegal arguments to factory method [" + method + "]; " + "args: " + StringUtils.arrayToCommaDelimitedString((Object[])objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BeanDefinitionStoreException("Cannot access factory method [" + method + "]; is it public?");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new BeanDefinitionStoreException("Factory method [" + method + "] threw exception", invocationTargetException.getTargetException());
        }
    }
}

