/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.Stack;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;

public final class ParserContext {
    private final XmlReaderContext readerContext;
    private final BeanDefinitionParserDelegate delegate;
    private BeanDefinition containingBeanDefinition;
    private final Stack containingComponents = new Stack();

    public ParserContext(XmlReaderContext xmlReaderContext, BeanDefinitionParserDelegate beanDefinitionParserDelegate) {
        this.readerContext = xmlReaderContext;
        this.delegate = beanDefinitionParserDelegate;
    }

    public ParserContext(XmlReaderContext xmlReaderContext, BeanDefinitionParserDelegate beanDefinitionParserDelegate, BeanDefinition beanDefinition) {
        this.readerContext = xmlReaderContext;
        this.delegate = beanDefinitionParserDelegate;
        this.containingBeanDefinition = beanDefinition;
    }

    public final XmlReaderContext getReaderContext() {
        return this.readerContext;
    }

    public final BeanDefinitionRegistry getRegistry() {
        return this.readerContext.getRegistry();
    }

    public final BeanDefinitionParserDelegate getDelegate() {
        return this.delegate;
    }

    public final BeanDefinition getContainingBeanDefinition() {
        return this.containingBeanDefinition;
    }

    public final boolean isNested() {
        return this.containingBeanDefinition != null;
    }

    public boolean isDefaultLazyInit() {
        return "true".equals(this.delegate.getDefaults().getLazyInit());
    }

    public Object extractSource(Object object) {
        return this.readerContext.extractSource(object);
    }

    public CompositeComponentDefinition getContainingComponent() {
        return !this.containingComponents.isEmpty() ? (CompositeComponentDefinition)this.containingComponents.lastElement() : null;
    }

    public void pushContainingComponent(CompositeComponentDefinition compositeComponentDefinition) {
        this.containingComponents.push(compositeComponentDefinition);
    }

    public CompositeComponentDefinition popContainingComponent() {
        return (CompositeComponentDefinition)this.containingComponents.pop();
    }

    public void popAndRegisterContainingComponent() {
        this.registerComponent(this.popContainingComponent());
    }

    public void registerComponent(ComponentDefinition componentDefinition) {
        CompositeComponentDefinition compositeComponentDefinition = this.getContainingComponent();
        if (compositeComponentDefinition != null) {
            compositeComponentDefinition.addNestedComponent(componentDefinition);
        } else {
            this.readerContext.fireComponentRegistered(componentDefinition);
        }
    }
}

