/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class UtilNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String SCOPE_ATTRIBUTE = "scope";
    static /* synthetic */ Class class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertyPathFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$ListFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$SetFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$MapFactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertiesFactoryBean;

    public void init() {
        this.registerBeanDefinitionParser("constant", new ConstantBeanDefinitionParser());
        this.registerBeanDefinitionParser("property-path", new PropertyPathBeanDefinitionParser());
        this.registerBeanDefinitionParser("list", new ListBeanDefinitionParser());
        this.registerBeanDefinitionParser("set", new SetBeanDefinitionParser());
        this.registerBeanDefinitionParser("map", new MapBeanDefinitionParser());
        this.registerBeanDefinitionParser("properties", new PropertiesBeanDefinitionParser());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ConstantBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private ConstantBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean == null ? (class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.FieldRetrievingFactoryBean")) : class$org$springframework$beans$factory$config$FieldRetrievingFactoryBean;
        }

        protected String resolveId(Element element, AbstractBeanDefinition abstractBeanDefinition, ParserContext parserContext) {
            String string = super.resolveId(element, abstractBeanDefinition, parserContext);
            if (!StringUtils.hasText((String)string)) {
                string = element.getAttribute("static-field");
            }
            return string;
        }
    }

    private static class ListBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private ListBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$ListFactoryBean == null ? (class$org$springframework$beans$factory$config$ListFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.ListFactoryBean")) : class$org$springframework$beans$factory$config$ListFactoryBean;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
            String string;
            String string2 = element.getAttribute("list-class");
            List list = parserContext.getDelegate().parseListElement(element, beanDefinitionBuilder.getRawBeanDefinition());
            beanDefinitionBuilder.addPropertyValue("sourceList", list);
            if (StringUtils.hasText((String)string2)) {
                beanDefinitionBuilder.addPropertyValue("targetListClass", string2);
            }
            if (StringUtils.hasLength((String)(string = element.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE)))) {
                beanDefinitionBuilder.setScope(string);
            }
        }
    }

    private static class MapBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private MapBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$MapFactoryBean == null ? (class$org$springframework$beans$factory$config$MapFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.MapFactoryBean")) : class$org$springframework$beans$factory$config$MapFactoryBean;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
            String string;
            String string2 = element.getAttribute("map-class");
            Map map = parserContext.getDelegate().parseMapElement(element, beanDefinitionBuilder.getRawBeanDefinition());
            beanDefinitionBuilder.addPropertyValue("sourceMap", map);
            if (StringUtils.hasText((String)string2)) {
                beanDefinitionBuilder.addPropertyValue("targetMapClass", string2);
            }
            if (StringUtils.hasLength((String)(string = element.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE)))) {
                beanDefinitionBuilder.setScope(string);
            }
        }
    }

    private static class PropertiesBeanDefinitionParser
    extends AbstractSimpleBeanDefinitionParser {
        private PropertiesBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$PropertiesFactoryBean == null ? (class$org$springframework$beans$factory$config$PropertiesFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.PropertiesFactoryBean")) : class$org$springframework$beans$factory$config$PropertiesFactoryBean;
        }

        protected boolean isEligibleAttribute(String string) {
            return super.isEligibleAttribute(string) && !UtilNamespaceHandler.SCOPE_ATTRIBUTE.equals(string);
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
            super.doParse(element, parserContext, beanDefinitionBuilder);
            Properties properties = parserContext.getDelegate().parsePropsElement(element);
            beanDefinitionBuilder.addPropertyValue("properties", properties);
            String string = element.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE);
            if (StringUtils.hasLength((String)string)) {
                beanDefinitionBuilder.setScope(string);
            }
        }
    }

    private static class PropertyPathBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private PropertyPathBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$PropertyPathFactoryBean == null ? (class$org$springframework$beans$factory$config$PropertyPathFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.PropertyPathFactoryBean")) : class$org$springframework$beans$factory$config$PropertyPathFactoryBean;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
            String string = element.getAttribute("path");
            if (!StringUtils.hasText((String)string)) {
                parserContext.getReaderContext().error("Attribute 'path' must not be empty", element);
                return;
            }
            int n = string.indexOf(".");
            if (n == -1) {
                parserContext.getReaderContext().error("Attribute 'path' must follow pattern 'beanName.propertyName'", element);
                return;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            beanDefinitionBuilder.addPropertyValue("targetBeanName", string2);
            beanDefinitionBuilder.addPropertyValue("propertyPath", string3);
        }

        protected String resolveId(Element element, AbstractBeanDefinition abstractBeanDefinition, ParserContext parserContext) {
            String string = super.resolveId(element, abstractBeanDefinition, parserContext);
            if (!StringUtils.hasText((String)string)) {
                string = element.getAttribute("path");
            }
            return string;
        }
    }

    private static class SetBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private SetBeanDefinitionParser() {
        }

        protected Class getBeanClass(Element element) {
            return class$org$springframework$beans$factory$config$SetFactoryBean == null ? (class$org$springframework$beans$factory$config$SetFactoryBean = UtilNamespaceHandler.class$("org.springframework.beans.factory.config.SetFactoryBean")) : class$org$springframework$beans$factory$config$SetFactoryBean;
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder beanDefinitionBuilder) {
            String string;
            String string2 = element.getAttribute("set-class");
            Set set = parserContext.getDelegate().parseSetElement(element, beanDefinitionBuilder.getRawBeanDefinition());
            beanDefinitionBuilder.addPropertyValue("sourceSet", set);
            if (StringUtils.hasText((String)string2)) {
                beanDefinitionBuilder.addPropertyValue("targetSetClass", string2);
            }
            if (StringUtils.hasLength((String)(string = element.getAttribute(UtilNamespaceHandler.SCOPE_ATTRIBUTE)))) {
                beanDefinitionBuilder.setScope(string);
            }
        }
    }
}

