/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class CharacterEditor
extends PropertyEditorSupport {
    private static final String UNICODE_PREFIX = "\\u";
    private static final int UNICODE_LENGTH = 6;
    private final boolean allowEmpty;

    public CharacterEditor(boolean bl) {
        this.allowEmpty = bl;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)string)) {
            this.setValue(null);
        } else {
            if (string == null) {
                throw new IllegalArgumentException("null String cannot be converted to char type");
            }
            if (CharacterEditor.isUnicodeCharacterSequence(string)) {
                this.setAsUnicode(string);
            } else {
                if (string.length() != 1) {
                    throw new IllegalArgumentException("String [" + string + "] with length " + string.length() + " cannot be converted to char type");
                }
                this.setValue(new Character(string.charAt(0)));
            }
        }
    }

    public String getAsText() {
        Object object = this.getValue();
        return object != null ? object.toString() : "";
    }

    private void setAsUnicode(String string) {
        int n = Integer.parseInt(string.substring(UNICODE_PREFIX.length()), 16);
        this.setValue(new Character((char)n));
    }

    private static boolean isUnicodeCharacterSequence(String string) {
        return string.startsWith(UNICODE_PREFIX) && string.length() == 6;
    }
}

