/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.core.CollectionFactory;

public class CustomMapEditor
extends PropertyEditorSupport {
    private final Class mapType;
    private final boolean nullAsEmptyMap;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$SortedMap;

    public CustomMapEditor(Class clazz) {
        this(clazz, false);
    }

    public CustomMapEditor(Class clazz, boolean bl) {
        if (clazz == null) {
            throw new IllegalArgumentException("Map type is required");
        }
        if (!(class$java$util$Map == null ? (class$java$util$Map = CustomMapEditor.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Map type [" + clazz.getName() + "] does not implement [java.util.Map]");
        }
        this.mapType = clazz;
        this.nullAsEmptyMap = bl;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public void setValue(Object object) {
        if (object == null && this.nullAsEmptyMap) {
            super.setValue(this.createMap(this.mapType, 0));
        } else if (object == null || this.mapType.isInstance(object) && !this.alwaysCreateNewMap()) {
            super.setValue(object);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            Map map2 = this.createMap(this.mapType, map.size());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                map2.put(this.convertKey(entry.getKey()), this.convertValue(entry.getValue()));
            }
            super.setValue(map2);
        } else {
            throw new IllegalArgumentException("Value cannot be converted to Map: " + object);
        }
    }

    protected Map createMap(Class clazz, int n) {
        if (!clazz.isInterface()) {
            try {
                return (Map)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Could not instantiate map class [" + clazz.getName() + "]: " + exception.getMessage());
            }
        }
        if ((class$java$util$SortedMap == null ? (class$java$util$SortedMap = CustomMapEditor.class$("java.util.SortedMap")) : class$java$util$SortedMap).equals(clazz)) {
            return new TreeMap();
        }
        return CollectionFactory.createLinkedMapIfPossible((int)n);
    }

    protected boolean alwaysCreateNewMap() {
        return false;
    }

    protected Object convertKey(Object object) {
        return object;
    }

    protected Object convertValue(Object object) {
        return object;
    }

    public String getAsText() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

