/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LoggingEvent;

public class HTMLLayout
extends Layout {
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    static String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    private StringBuffer sbuf = new StringBuffer(256);
    public static final String LOCATION_INFO_OPTION = "LocationInfo";
    public static final String TITLE_OPTION = "Title";
    boolean locationInfo = false;
    String title = "Log4J Log Messages";

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContentType() {
        return "text/html";
    }

    public void activateOptions() {
    }

    public String format(LoggingEvent loggingEvent) {
        String[] stringArray;
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        this.sbuf.append(Layout.LINE_SEP + "<tr>" + Layout.LINE_SEP);
        this.sbuf.append("<td>");
        this.sbuf.append(loggingEvent.timeStamp - LoggingEvent.getStartTime());
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"" + loggingEvent.getThreadName() + " thread\">");
        this.sbuf.append(Transform.escapeTags(loggingEvent.getThreadName()));
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"Level\">");
        if (loggingEvent.getLevel().equals(Level.DEBUG)) {
            this.sbuf.append("<font color=\"#339933\">");
            this.sbuf.append(loggingEvent.getLevel());
            this.sbuf.append("</font>");
        } else if (loggingEvent.getLevel().isGreaterOrEqual(Level.WARN)) {
            this.sbuf.append("<font color=\"#993300\"><strong>");
            this.sbuf.append(loggingEvent.getLevel());
            this.sbuf.append("</strong></font>");
        } else {
            this.sbuf.append(loggingEvent.getLevel());
        }
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"" + loggingEvent.getLoggerName() + " category\">");
        this.sbuf.append(Transform.escapeTags(loggingEvent.getLoggerName()));
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        if (this.locationInfo) {
            stringArray = loggingEvent.getLocationInformation();
            this.sbuf.append("<td>");
            this.sbuf.append(Transform.escapeTags(stringArray.getFileName()));
            this.sbuf.append(':');
            this.sbuf.append(stringArray.getLineNumber());
            this.sbuf.append("</td>" + Layout.LINE_SEP);
        }
        this.sbuf.append("<td title=\"Message\">");
        this.sbuf.append(Transform.escapeTags(loggingEvent.getRenderedMessage()));
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("</tr>" + Layout.LINE_SEP);
        if (loggingEvent.getNDC() != null) {
            this.sbuf.append("<tr><td bgcolor=\"#EEEEEE\" style=\"font-size : xx-small;\" colspan=\"6\" title=\"Nested Diagnostic Context\">");
            this.sbuf.append("NDC: " + Transform.escapeTags(loggingEvent.getNDC()));
            this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
        }
        if ((stringArray = loggingEvent.getThrowableStrRep()) != null) {
            this.sbuf.append("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : xx-small;\" colspan=\"6\">");
            this.appendThrowableAsHTML(stringArray, this.sbuf);
            this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
        }
        return this.sbuf.toString();
    }

    void appendThrowableAsHTML(String[] stringArray, StringBuffer stringBuffer) {
        if (stringArray != null) {
            int n = stringArray.length;
            if (n == 0) {
                return;
            }
            stringBuffer.append(Transform.escapeTags(stringArray[0]));
            stringBuffer.append(Layout.LINE_SEP);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(TRACE_PREFIX);
                stringBuffer.append(Transform.escapeTags(stringArray[n2]));
                stringBuffer.append(Layout.LINE_SEP);
                ++n2;
            }
        }
    }

    public String getHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + Layout.LINE_SEP);
        stringBuffer.append("<html>" + Layout.LINE_SEP);
        stringBuffer.append("<head>" + Layout.LINE_SEP);
        stringBuffer.append("<title>" + this.title + "</title>" + Layout.LINE_SEP);
        stringBuffer.append("<style type=\"text/css\">" + Layout.LINE_SEP);
        stringBuffer.append("<!--" + Layout.LINE_SEP);
        stringBuffer.append("body, table {font-family: arial,sans-serif; font-size: x-small;}" + Layout.LINE_SEP);
        stringBuffer.append("th {background: #336699; color: #FFFFFF; text-align: left;}" + Layout.LINE_SEP);
        stringBuffer.append("-->" + Layout.LINE_SEP);
        stringBuffer.append("</style>" + Layout.LINE_SEP);
        stringBuffer.append("</head>" + Layout.LINE_SEP);
        stringBuffer.append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\">" + Layout.LINE_SEP);
        stringBuffer.append("<hr size=\"1\" noshade>" + Layout.LINE_SEP);
        stringBuffer.append("Log session start time " + new Date() + "<br>" + Layout.LINE_SEP);
        stringBuffer.append("<br>" + Layout.LINE_SEP);
        stringBuffer.append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">" + Layout.LINE_SEP);
        stringBuffer.append("<tr>" + Layout.LINE_SEP);
        stringBuffer.append("<th>Time</th>" + Layout.LINE_SEP);
        stringBuffer.append("<th>Thread</th>" + Layout.LINE_SEP);
        stringBuffer.append("<th>Level</th>" + Layout.LINE_SEP);
        stringBuffer.append("<th>Category</th>" + Layout.LINE_SEP);
        if (this.locationInfo) {
            stringBuffer.append("<th>File:Line</th>" + Layout.LINE_SEP);
        }
        stringBuffer.append("<th>Message</th>" + Layout.LINE_SEP);
        stringBuffer.append("</tr>" + Layout.LINE_SEP);
        return stringBuffer.toString();
    }

    public String getFooter() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("</table>" + Layout.LINE_SEP);
        stringBuffer.append("<br>" + Layout.LINE_SEP);
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }
}

